/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.svg;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.app4mc.amalthea.visualizations.svg.AbstractConfig;
import org.eclipse.app4mc.amalthea.visualizations.svg.Context;
import org.eclipse.app4mc.visualization.util.svg.SvgUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractVisualization {
    protected void addToggleButton(Composite parent, String text, String toolTip, Consumer<Boolean> f, boolean initialSelected) {
        Button btn = new Button(parent, 0x800002);
        btn.setText(text);
        btn.setToolTipText(toolTip);
        btn.setSelection(initialSelected);
        btn.addListener(13, e -> f.accept(btn.getSelection()));
    }

    protected void addZoomBox(Composite buttonArea, AbstractConfig config) {
        Composite zoomArea = new Composite(buttonArea, 0);
        RowLayoutFactory.fillDefaults().margins(1, 1).applyTo(zoomArea);
        Composite box = new Composite(zoomArea, 2048);
        Button btnLeft = new Button(box, 0x804004);
        btnLeft.addListener(13, e -> {
            boolean bl = config.decrementScale();
        });
        CLabel scaleLabel = new CLabel(box, 0x1800000);
        scaleLabel.setText(String.format("%d %%", config.getScale()));
        config.addChangeListener(e -> {
            if (e.getPropertyName().equals("scale")) {
                scaleLabel.setText(String.format("%d %%", (int)((Integer)e.getNewValue())));
            }
        });
        Button btnRight = new Button(box, 8519684);
        btnRight.addListener(13, e -> {
            boolean bl = config.incrementScale();
        });
        RowLayoutFactory.fillDefaults().fill(true).applyTo(box);
    }

    protected Browser addBrowser(Composite pane, IEventBroker broker, Context context) {
        Browser browser = new Browser(pane, 0);
        if (broker != null) {
            browser.addLocationListener(LocationListener.changingAdapter(c -> {
                c.doit = true;
                Object target = null;
                int idx = c.location.lastIndexOf(35);
                if (idx >= 0) {
                    target = context.diagram.getObjectById(c.location.substring(idx + 1));
                }
                if (target != null) {
                    HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
                    data.put("modelElements", Collections.singletonList(target));
                    broker.send("org/eclipse/app4mc/amalthea/editor/SELECT", data);
                    c.doit = false;
                }
            }));
        }
        context.config.addChangeListener(e -> {
            if (e.getPropertyName().equals("scale")) {
                this.updateSvgScale(browser, (Integer)e.getNewValue());
            }
            if (e.getPropertyName().startsWith("parameter")) {
                this.updateBrowserContent(browser, context);
            }
        });
        return browser;
    }

    protected void updateSvgScale(Browser browser, int newScale) {
        if (browser != null) {
            browser.execute(SvgUtil.buildUpdateScaleCommand((int)newScale));
        }
    }

    protected void updateBrowserContent(Browser browser, Context context) {
        new Thread(() -> {
            String result;
            this.updateDiagram(context);
            try {
                result = context.diagram.renderToSvg();
            }
            catch (IOException e) {
                String result2 = "Error invoking PlantUML: \"" + e.getMessage() + "\". Make sure you have configured the path to the dot executable properly in the PlantUML preferences.";
                Platform.getLog(AbstractVisualization.class).error(result2, (Throwable)e);
                return;
            }
            if (result != null && !browser.isDisposed()) {
                String browserContent = SvgUtil.initiallyApplyScale((String)result, (int)context.config.getScale());
                browser.getDisplay().asyncExec(() -> {
                    if (!browser.isDisposed()) {
                        browser.setText(browserContent);
                    }
                });
            }
        }).start();
    }

    protected abstract void updateDiagram(Context var1);
}

