/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.svg;

import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.visualizations.svg.AbstractVisualization;
import org.eclipse.app4mc.amalthea.visualizations.svg.Context;
import org.eclipse.app4mc.amalthea.visualizations.svg.HardwareStructureConfig;
import org.eclipse.app4mc.amalthea.visualizations.svg.HardwareStructureGenerator;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.app4mc.visualization.util.svg.AbstractDiagram;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Hardware Structure", "description=Block Diagram Visualization for the hardware model"})
public class HardwareStructureVisualization2
extends AbstractVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(HWModel hwModel, VisualizationParameters parameters, Composite parent, IEventBroker broker) {
        HardwareStructureConfig config = new HardwareStructureConfig(parameters);
        Context context = this.createContext(hwModel, config);
        Composite pane = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(pane);
        Composite buttonArea = new Composite(pane, 0);
        this.addToggleButton(buttonArea, "Show Modules", "Show modules (processing units, caches, memories, connection handlers)", config::setShowModules, config.isShowModules());
        this.addToggleButton(buttonArea, "Show Physical Connections", "Show physical connections of software structures", config::setShowPhysicalConnections, config.isShowPhysicalConnections());
        this.addToggleButton(buttonArea, "Show Logical Connections", "Show locical connections of processing units", config::setShowLogicalConnections, config.isShowLogicalConnections());
        this.addZoomBox(buttonArea, context.config);
        RowLayoutFactory.swtDefaults().fill(true).applyTo(buttonArea);
        Browser browser = this.addBrowser(pane, broker, context);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)browser);
        this.updateBrowserContent(browser, context);
    }

    private Context createContext(HWModel hwModel, HardwareStructureConfig config) {
        return new Context(hwModel.getStructures(), config, (AbstractDiagram)new PlantUmlDiagram());
    }

    @Override
    protected void updateDiagram(Context context) {
        HardwareStructureGenerator.updateDiagram(context);
    }
}

