/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.sw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="Inchron-SW-Task-NotAllocated-DifferentSchedulers", checks={"Task cannot be scheduled by more than one OS"})
public class InchronSWInvalidTaskAllocation
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getTask();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        EObject eObject2 = eObject;
        if (eObject2 instanceof Task) {
            void task;
            Task task2 = (Task)eObject2;
            Task cfr_ignored_0 = (Task)eObject2;
            Set taskAllocations = AmaltheaIndex.getReferringObjects((EObject)task, TaskAllocation.class);
            HashSet<void> osSet = new HashSet<void>();
            for (TaskAllocation taskAllocation : taskAllocations) {
                void os;
                EObject eObject3;
                TaskScheduler sched = taskAllocation.getScheduler();
                if (sched == null || !((eObject3 = sched.eContainer()) instanceof OperatingSystem)) continue;
                OperatingSystem cfr_ignored_1 = (OperatingSystem)eObject3;
                OperatingSystem cfr_ignored_2 = (OperatingSystem)eObject3;
                osSet.add(os);
            }
            ArrayList<String> ar = new ArrayList<String>();
            if (osSet.size() > 1) {
                for (OperatingSystem operatingSystem : osSet) {
                    if (operatingSystem.getName() == null) continue;
                    ar.add(operatingSystem.getName());
                }
                Collections.sort(ar);
                String string = String.join((CharSequence)",", ar);
                this.addIssue(results, (EObject)task, null, "Task " + this.name((INamed)task) + " is scheduled by more than one operating system: " + string);
            }
        }
    }
}

