/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf.model;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.app4mc.amalthea.model.ProcessEventType;
import org.eclipse.app4mc.amalthea.model.RunnableEventType;
import org.eclipse.app4mc.atdb._import.btf.model.BTFCountMetric;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;

public enum BTFEntityState {
    notInitialized(new AbstractMap.SimpleEntry<List<T>, List<RunnableEventType>>(Collections.emptyList(), List.of(RunnableEventType.START)), new AbstractMap.SimpleEntry<List<T>, List<ProcessEventType>>(Collections.emptyList(), List.of(ProcessEventType.ACTIVATE))),
    startDelay(new AbstractMap.SimpleEntry<List<ProcessEventType>, List<ProcessEventType>>(List.of(ProcessEventType.ACTIVATE), List.of(ProcessEventType.START))),
    running(new AbstractMap.SimpleEntry<List<RunnableEventType>, List<RunnableEventType>>(List.of(RunnableEventType.START, RunnableEventType.RESUME), List.of(RunnableEventType.TERMINATE, RunnableEventType.SUSPEND)), new AbstractMap.SimpleEntry<List<ProcessEventType>, List<ProcessEventType>>(List.of(ProcessEventType.START, ProcessEventType.RESUME, ProcessEventType.RUN), List.of(ProcessEventType.TERMINATE, ProcessEventType.PREEMPT, ProcessEventType.POLL, ProcessEventType.WAIT))),
    polling(new AbstractMap.SimpleEntry<List<ProcessEventType>, List<ProcessEventType>>(List.of(ProcessEventType.POLL, ProcessEventType.POLL_PARKING), List.of(ProcessEventType.RUN, ProcessEventType.PARK))),
    parking(new AbstractMap.SimpleEntry<List<ProcessEventType>, List<ProcessEventType>>(List.of(ProcessEventType.PARK), List.of(ProcessEventType.POLL_PARKING, ProcessEventType.RELEASE_PARKING))),
    waiting(new AbstractMap.SimpleEntry<List<ProcessEventType>, List<ProcessEventType>>(List.of(ProcessEventType.WAIT), List.of(ProcessEventType.RELEASE))),
    ready(new AbstractMap.SimpleEntry<List<RunnableEventType>, List<RunnableEventType>>(List.of(RunnableEventType.SUSPEND), List.of(RunnableEventType.RESUME)), new AbstractMap.SimpleEntry<List<ProcessEventType>, List<ProcessEventType>>(List.of(ProcessEventType.PREEMPT, ProcessEventType.RELEASE, ProcessEventType.RELEASE_PARKING), List.of(ProcessEventType.RESUME))),
    response(new AbstractMap.SimpleEntry<List<ProcessEventType>, List<ProcessEventType>>(List.of(ProcessEventType.ACTIVATE), List.of(ProcessEventType.TERMINATE))),
    terminated(new AbstractMap.SimpleEntry<List<RunnableEventType>, List<T>>(List.of(RunnableEventType.TERMINATE), Collections.emptyList()), new AbstractMap.SimpleEntry<List<ProcessEventType>, List<T>>(List.of(ProcessEventType.TERMINATE), Collections.emptyList()));

    public final Map<BTFEntityType, Map.Entry<List<Enum<?>>, List<Enum<?>>>> entityType2InOutEvents = new LinkedHashMap();
    public static final List<BTFEntityState> actStates;

    static {
        actStates = Stream.of(BTFEntityState.values()).filter(p -> p.entityType2InOutEvents.values().stream().noneMatch(e -> ((List)e.getKey()).isEmpty())).filter(p -> p.entityType2InOutEvents.values().stream().noneMatch(e -> ((List)e.getValue()).isEmpty())).toList();
    }

    @SafeVarargs
    private BTFEntityState(Map.Entry<List<Enum<?>>, List<Enum<?>>> ... inOutEvents) {
        Stream.of(inOutEvents).forEach(e -> {
            String entityTypeName = ((List)e.getKey()).stream().findFirst().orElseGet(((List)e.getValue()).stream().findFirst()::get).getClass().getSimpleName();
            entityTypeName = entityTypeName.substring(0, entityTypeName.indexOf("EventType")).toLowerCase();
            this.entityType2InOutEvents.put(BTFEntityType.getForName(entityTypeName), (Map.Entry<List<Enum<?>>, List<Enum<?>>>)e);
        });
    }

    public static List<String> getValidityConstraints(BTFEntityType entityType) {
        ArrayList<String> validityConstraints = new ArrayList<String>();
        Stream.of(BTFEntityState.values()).filter(s -> !actStates.contains(s)).map(s -> s.entityType2InOutEvents.get((Object)entityType)).filter(Objects::nonNull).forEach(entry -> {
            ((List)entry.getKey()).forEach(e -> {
                boolean bl = validityConstraints.add(String.valueOf(e.toString().toLowerCase()) + "EventCount = 1");
            });
            ((List)entry.getValue()).forEach(e -> {
                boolean bl = validityConstraints.add(String.valueOf(e.toString().toLowerCase()) + "EventCount = 1");
            });
        });
        actStates.stream().map(s -> s.entityType2InOutEvents.get((Object)entityType)).filter(Objects::nonNull).forEach(entry -> {
            LinkedHashSet loopEvents = new LinkedHashSet((Collection)entry.getKey());
            loopEvents.retainAll((Collection)entry.getValue());
            String left = ((List)entry.getKey()).stream().filter(e -> !loopEvents.contains(e)).map(e -> String.valueOf(e.toString().toLowerCase()) + "EventCount").collect(Collectors.joining(" + "));
            String right = ((List)entry.getValue()).stream().filter(e -> !loopEvents.contains(e)).map(e -> String.valueOf(e.toString().toLowerCase()) + "EventCount").collect(Collectors.joining(" + "));
            validityConstraints.add(String.valueOf(left) + " = " + right);
        });
        return validityConstraints;
    }

    public static Set<Enum<?>> getPossibleEventsFor(BTFEntityType entityType) {
        LinkedHashSet result = new LinkedHashSet(BTFCountMetric.getInvolvedBTFEventsForEntityType(entityType));
        Stream.of(BTFEntityState.values()).map(s -> s.entityType2InOutEvents.get((Object)entityType)).filter(Objects::nonNull).flatMap(e -> Stream.concat(((List)e.getKey()).stream(), ((List)e.getValue()).stream())).distinct().forEach(result::add);
        return result;
    }
}

