/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.app4mc.amalthea._import.atdb.AConverter;
import org.eclipse.app4mc.amalthea._import.atdb.AmaltheaModelUtil;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ITimeDeviation;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeBoundaries;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.MetricAggregation;
import org.eclipse.emf.ecore.EObject;

public class StimulusConverter
extends AConverter {
    private static final String a2a = "activateToActivate_";

    public StimulusConverter(Amalthea model, ATDBConnection con) {
        super(model, con, "stimuli");
    }

    @Override
    protected void execute() throws SQLException {
        StimuliModel stimuliModel = ModelUtil.getOrCreateStimuliModel((Amalthea)this.model);
        TimeUnit timeBase = TimeUnit.getByName((String)this.con.getTimeBase().toLowerCase());
        ArrayList<PeriodicStimulus> stimuli = new ArrayList<PeriodicStimulus>();
        for (String stimulusName : this.con.getAllStimuli()) {
            if (this.con.getAllInstancesForEntity(stimulusName).size() == 1) {
                try {
                    long occurrence = Long.parseLong(this.con.getValueForMetricAndEntity(stimulusName, a2a + MetricAggregation.Min));
                    SingleStimulus singStimme = AmaltheaModelUtil.getOrAddNew((EObject)stimuliModel, AmaltheaPackage.eINSTANCE.getStimuliModel_Stimuli(), stimulusName, SingleStimulus.class, AmaltheaPackage.eINSTANCE.getSingleStimulus());
                    Time occurrenceTime = FactoryUtil.createTime((long)occurrence, (TimeUnit)timeBase).adjustUnit();
                    singStimme.setOccurrence(occurrenceTime);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            PeriodicStimulus stimulus = AmaltheaModelUtil.getOrAddNew((EObject)stimuliModel, AmaltheaPackage.eINSTANCE.getStimuliModel_Stimuli(), stimulusName, PeriodicStimulus.class, AmaltheaPackage.eINSTANCE.getPeriodicStimulus());
            stimuli.add(stimulus);
        }
        for (PeriodicStimulus stimulus : stimuli) {
            double periodAvg = -1.0;
            double periodStDev = -1.0;
            try {
                periodAvg = Double.parseDouble(this.con.getValueForMetricAndEntity(stimulus.getName(), a2a + MetricAggregation.Avg));
                periodStDev = Double.parseDouble(this.con.getValueForMetricAndEntity(stimulus.getName(), a2a + MetricAggregation.StDev));
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                TimeBoundaries jitterDev;
                long periodMin = Long.parseLong(this.con.getValueForMetricAndEntity(stimulus.getName(), a2a + MetricAggregation.Min));
                long periodMax = Long.parseLong(this.con.getValueForMetricAndEntity(stimulus.getName(), a2a + MetricAggregation.Max));
                if (periodMin == periodMax) {
                    Time recurrence = FactoryUtil.createTime((long)periodMin, (TimeUnit)timeBase).adjustUnit();
                    stimulus.setRecurrence(recurrence);
                    continue;
                }
                if (periodAvg <= -1.0) {
                    periodAvg = (double)(periodMin + periodMax) / 2.0;
                }
                Time avgRecurrence = FactoryUtil.createTime((double)periodAvg, (TimeUnit)timeBase).adjustUnit();
                stimulus.setRecurrence(avgRecurrence);
                Time minJitter = FactoryUtil.createTime((double)((double)periodMin - periodAvg), (TimeUnit)timeBase).adjustUnit();
                Time maxJitter = FactoryUtil.createTime((double)((double)periodMax - periodAvg), (TimeUnit)timeBase).adjustUnit();
                if (periodStDev >= 0.0) {
                    Time stDevJitter = FactoryUtil.createTime((double)periodStDev, (TimeUnit)timeBase).adjustUnit();
                    Time avgZeroJitter = FactoryUtil.createTime((long)0L, (TimeUnit)timeBase).adjustUnit();
                    jitterDev = FactoryUtil.createTimeGaussDistribution((Time)avgZeroJitter, (Time)stDevJitter, (Time)minJitter, (Time)maxJitter);
                } else {
                    jitterDev = FactoryUtil.createTimeBoundaries((Time)minJitter, (Time)maxJitter);
                }
                stimulus.setJitter((ITimeDeviation)jitterDev);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

