/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Strings;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ContinuousValueInterval;
import org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics;
import org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueInterval;
import org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics;
import org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.EnumMode;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.Mode;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.NumericMode;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeInterval;
import org.eclipse.app4mc.amalthea.model.TimeStatistics;
import org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.TruncatedContinuousValueDistribution;
import org.eclipse.app4mc.amalthea.model.TruncatedDiscreteValueDistribution;
import org.eclipse.app4mc.amalthea.model.TruncatedTimeDistribution;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AmaltheaValidations {
    private static final String DIAGNOSTIC_SOURCE = "org.eclipse.app4mc.amalthea.model";
    private static final int NO_INDEX = -1;
    private static final AmaltheaPackage PACKAGE = AmaltheaPackage.eINSTANCE;

    private AmaltheaValidations() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean validateInvariants(MinAvgMaxStatistic obj, DiagnosticChain diagnostics) {
        boolean isValid;
        boolean bl = isValid = (float)obj.getMin() <= obj.getAvg() && obj.getAvg() <= (float)obj.getMax();
        if (!isValid) {
            AmaltheaValidations.addError(obj, (EStructuralFeature)PACKAGE.getMinAvgMaxStatistic_Avg(), "MinAvgMaxStatistic: constraint min <= avg <= max violated", diagnostics);
        }
        return isValid;
    }

    public static boolean validateInvariants(TimeInterval obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, obj.getLowerBound(), AmaltheaValidations.getAverage(obj), obj.getUpperBound());
    }

    public static boolean validateInvariants(DiscreteValueInterval obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, AmaltheaValidations.toDouble(obj.getLowerBound()), AmaltheaValidations.getAverage(obj), AmaltheaValidations.toDouble(obj.getUpperBound()));
    }

    public static boolean validateInvariants(ContinuousValueInterval obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, obj.getLowerBound(), AmaltheaValidations.getAverage(obj), obj.getUpperBound());
    }

    public static boolean validateInvariants(TruncatedTimeDistribution obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, obj.getLowerBound(), null, obj.getUpperBound());
    }

    public static boolean validateInvariants(TruncatedDiscreteValueDistribution obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, AmaltheaValidations.toDouble(obj.getLowerBound()), null, AmaltheaValidations.toDouble(obj.getUpperBound()));
    }

    public static boolean validateInvariants(TruncatedContinuousValueDistribution obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, obj.getLowerBound(), null, obj.getUpperBound());
    }

    private static Time getAverage(TimeInterval obj) {
        Time avg = null;
        if (obj instanceof TimeStatistics) {
            avg = ((TimeStatistics)obj).getAverage();
        }
        if (obj instanceof TimeWeibullEstimatorsDistribution) {
            avg = ((TimeWeibullEstimatorsDistribution)obj).getAverage();
        }
        return avg;
    }

    private static Double getAverage(DiscreteValueInterval obj) {
        Double avg = null;
        if (obj instanceof DiscreteValueStatistics) {
            avg = ((DiscreteValueStatistics)obj).getAverage();
        }
        if (obj instanceof DiscreteValueWeibullEstimatorsDistribution) {
            avg = ((DiscreteValueWeibullEstimatorsDistribution)obj).getAverage();
        }
        return avg;
    }

    private static Double getAverage(ContinuousValueInterval obj) {
        Double avg = null;
        if (obj instanceof ContinuousValueStatistics) {
            avg = ((ContinuousValueStatistics)obj).getAverage();
        }
        if (obj instanceof ContinuousValueWeibullEstimatorsDistribution) {
            avg = ((ContinuousValueWeibullEstimatorsDistribution)obj).getAverage();
        }
        return avg;
    }

    private static Double toDouble(Long value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    private static <T extends Comparable<T>> boolean checkMinAvgMax(EObject obj, DiagnosticChain diagnostics, T min, T avg, T max) {
        boolean isValid = true;
        if (min != null && max != null && min.compareTo(max) > 0) {
            AmaltheaValidations.addError(obj, null, String.valueOf(obj.eClass().getName()) + ": lower bound > upper bound", diagnostics);
            isValid = false;
        }
        if (min != null && avg != null && min.compareTo(avg) > 0) {
            AmaltheaValidations.addError(obj, null, String.valueOf(obj.eClass().getName()) + ": lower bound > average", diagnostics);
            isValid = false;
        }
        if (avg != null && max != null && avg.compareTo(max) > 0) {
            AmaltheaValidations.addError(obj, null, String.valueOf(obj.eClass().getName()) + ": average > upper bound", diagnostics);
            isValid = false;
        }
        return isValid;
    }

    public static boolean validateInvariants(IReferable obj, DiagnosticChain diagnostics) {
        boolean isValid;
        boolean bl = isValid = !Strings.isNullOrEmpty((String)obj.getName());
        if (!isValid) {
            AmaltheaValidations.addError(obj, (EStructuralFeature)PACKAGE.getINamed_Name(), String.valueOf(obj.eClass().getName()) + ": missing name", diagnostics);
        }
        return isValid;
    }

    public static boolean validateInvariants(ModeLabel obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkModeAndValue(obj, (EStructuralFeature)PACKAGE.getModeLabel_InitialValue(), obj.getMode(), obj.getInitialValue(), diagnostics);
    }

    public static boolean validateInvariants(ModeValue obj, DiagnosticChain diagnostics) {
        ModeLabel modeLabel = obj.getLabel();
        if (modeLabel == null) {
            AmaltheaValidations.addError(obj, (EStructuralFeature)PACKAGE.getModeValue_Label(), String.valueOf(obj.eClass().getName()) + ": missing mode label", diagnostics);
            return false;
        }
        return AmaltheaValidations.checkModeAndValue(obj, (EStructuralFeature)PACKAGE.getModeValue_Value(), modeLabel.getMode(), obj.getValue(), diagnostics);
    }

    public static boolean validateInvariants(ModeLabelAccess obj, DiagnosticChain diagnostics) {
        ModeLabel modeLabel = obj.getData();
        if (modeLabel == null) {
            AmaltheaValidations.addError(obj, (EStructuralFeature)PACKAGE.getModeLabelAccess_Data(), String.valueOf(obj.eClass().getName()) + ": missing mode label", diagnostics);
            return false;
        }
        if (obj.getAccess() == ModeLabelAccessEnum.SET) {
            return AmaltheaValidations.checkModeAndValue(obj, (EStructuralFeature)PACKAGE.getModeLabelAccess_Value(), modeLabel.getMode(), obj.getValue(), diagnostics);
        }
        return true;
    }

    private static boolean checkModeAndValue(EObject obj, EStructuralFeature feature, Mode mode, String value, DiagnosticChain diagnostics) {
        boolean isInteger;
        EnumMode enumMode;
        if (mode == null) {
            AmaltheaValidations.addWarning(obj, feature, String.valueOf(obj.eClass().getName()) + ": unknown value type (mode)", diagnostics);
            return false;
        }
        if (value == null) {
            if (feature.getLowerBound() != 0) {
                AmaltheaValidations.addError(obj, feature, String.valueOf(obj.eClass().getName()) + ": missing value", diagnostics);
                return false;
            }
            return true;
        }
        String trimmedValue = value.trim();
        if (mode instanceof EnumMode && (enumMode = (EnumMode)mode).getLiteral(trimmedValue) == null) {
            AmaltheaValidations.addError(obj, feature, "The " + feature.getName() + " '" + trimmedValue + "' is not a valid literal of Enum Mode \"" + mode.getName() + "\"", diagnostics);
            return false;
        }
        if (mode instanceof NumericMode && !(isInteger = trimmedValue.matches("-?\\d+"))) {
            AmaltheaValidations.addError(obj, feature, "The " + feature.getName() + " '" + trimmedValue + "' is not an integer", diagnostics);
            return false;
        }
        return true;
    }

    private static void addWarning(EObject object, EStructuralFeature feature, String message, DiagnosticChain diagnostics) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)AmaltheaValidations.createIssue(2, object, feature, message));
        }
    }

    private static void addError(EObject object, EStructuralFeature feature, String message, DiagnosticChain diagnostics) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)AmaltheaValidations.createIssue(4, object, feature, message));
        }
    }

    private static BasicDiagnostic createIssue(int severity, EObject object, EStructuralFeature feature, String message) {
        return new BasicDiagnostic(severity, DIAGNOSTIC_SOURCE, -1, message, new Object[]{object, feature});
    }
}

