/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb.metrics;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.eclipse.app4mc.atdb.metrics.Messages;
import org.eclipse.nebula.widgets.nattable.data.AutomaticSpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;

public final class DBResultRowDataProvider
implements IRowDataProvider<List<String>>,
ISpanningDataProvider {
    private final int columnCount;
    private final BiMap<Integer, List<String>> rowIndex2DataValue = HashBiMap.create();
    private final IDataProvider columnsHeaderDataProvider;
    private final IDataProvider rowHeaderDataProvider;
    private final ISpanningDataProvider rowSpanningDataProvider;
    private final List<Integer> groupByColumnIndices;

    static DBResultRowDataProvider of(ResultSet rs, List<Integer> groupByColumnIndices) throws SQLException {
        return new DBResultRowDataProvider(rs, groupByColumnIndices);
    }

    private DBResultRowDataProvider(ResultSet rs, List<Integer> groupByColumnIndices) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        ArrayList<String> columneHeaderNames = new ArrayList<String>();
        int i = 1;
        while (i <= colCount) {
            columneHeaderNames.add(rsmd.getColumnName(i));
            ++i;
        }
        while (rs.next()) {
            ArrayList<String> resultRow = new ArrayList<String>();
            int i2 = 1;
            while (i2 <= colCount) {
                resultRow.add(rs.getString(i2));
                ++i2;
            }
            this.rowIndex2DataValue.put((Object)(rs.getRow() - 1), resultRow);
        }
        this.columnsHeaderDataProvider = new DefaultColumnHeaderDataProvider(columneHeaderNames.toArray(new String[colCount]));
        this.rowSpanningDataProvider = new AutomaticSpanningDataProvider((IDataProvider)this, false, true);
        this.rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)this.rowSpanningDataProvider);
        this.columnCount = colCount;
        this.groupByColumnIndices = Collections.unmodifiableList(groupByColumnIndices);
    }

    public String getDataValue(int columnIndex, int rowIndex) {
        return (String)((List)this.rowIndex2DataValue.get((Object)rowIndex)).get(columnIndex);
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException(Messages.DBViewer_immutableResultError);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowIndex2DataValue.size();
    }

    public List<String> getRowObject(int rowIndex) {
        return (List)this.rowIndex2DataValue.get((Object)rowIndex);
    }

    public int indexOfRowObject(List<String> rowObject) {
        return (Integer)this.rowIndex2DataValue.inverse().get(rowObject);
    }

    public IDataProvider getColumnHeaderDataProvider() {
        return this.columnsHeaderDataProvider;
    }

    public IDataProvider getRowHeaderDataProvider() {
        return this.rowHeaderDataProvider;
    }

    public void initializeGroups(RowGroupHeaderLayer rowGroupHeaderLayer) {
        if (this.groupByColumnIndices.isEmpty()) {
            return;
        }
        IntStream.range(rowGroupHeaderLayer.getLevelCount(), this.groupByColumnIndices.size()).forEach(i -> rowGroupHeaderLayer.addGroupingLevel());
        HashBasedTable levelGroupTuple2StartIndex = HashBasedTable.create();
        LinkedHashMap<Integer, String> level2currentGroup = new LinkedHashMap<Integer, String>();
        for (Map.Entry entry : this.rowIndex2DataValue.entrySet()) {
            int absIndex = (Integer)entry.getKey();
            List row = (List)entry.getValue();
            int level = 0;
            while (level < this.groupByColumnIndices.size()) {
                int columnIndex = this.groupByColumnIndices.get(level);
                String groupCellValue = (String)row.get(columnIndex);
                if (!levelGroupTuple2StartIndex.contains((Object)level, (Object)groupCellValue)) {
                    if (level2currentGroup.containsKey(level)) {
                        String currentGroupName = (String)level2currentGroup.get(level);
                        int startIndex = (Integer)levelGroupTuple2StartIndex.get((Object)level, (Object)currentGroupName);
                        rowGroupHeaderLayer.addGroup(level, currentGroupName, startIndex, absIndex - startIndex);
                        levelGroupTuple2StartIndex.remove((Object)level, (Object)currentGroupName);
                    }
                    level2currentGroup.put(level, groupCellValue);
                    levelGroupTuple2StartIndex.put((Object)level, (Object)groupCellValue, (Object)absIndex);
                }
                ++level;
            }
        }
        int level = 0;
        while (level < this.groupByColumnIndices.size()) {
            if (level2currentGroup.containsKey(level)) {
                String currentGroupName = (String)level2currentGroup.get(level);
                int startIndex = (Integer)levelGroupTuple2StartIndex.get((Object)level, (Object)currentGroupName);
                rowGroupHeaderLayer.addGroup(level, currentGroupName, startIndex, this.rowIndex2DataValue.size() - startIndex);
                levelGroupTuple2StartIndex.remove((Object)level, (Object)currentGroupName);
            }
            ++level;
        }
    }

    public DataCell getCellByPosition(int columnPosition, int rowPosition) {
        return this.rowSpanningDataProvider.getCellByPosition(columnPosition, rowPosition);
    }
}

