/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.core.IValidation;
import org.eclipse.app4mc.validation.core.Severity;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.app4mc.validation.util.CachedValidator;
import org.eclipse.app4mc.validation.util.ValidationAggregator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ValidationExecutor {
    private static final String SEPARATOR = "--------------------------------";
    private final ConcurrentMap<EClassifier, CopyOnWriteArraySet<CachedValidator>> validationMap;
    private final ConcurrentLinkedQueue<ValidationDiagnostic> results = new ConcurrentLinkedQueue();

    public ValidationExecutor(Class<? extends IProfile> profileClass) {
        if (profileClass == null) {
            throw new IllegalArgumentException("Loading aborted - Undefined profile class (null)");
        }
        ValidationAggregator validationAggregator = new ValidationAggregator();
        validationAggregator.addProfile(profileClass);
        this.validationMap = validationAggregator.getConcurrentValidationMap();
    }

    public ValidationExecutor(Collection<Class<? extends IProfile>> profileClasses) {
        if (profileClasses == null || profileClasses.isEmpty()) {
            throw new IllegalArgumentException("Loading aborted - Undefined profile classes");
        }
        ValidationAggregator validationAggregator = new ValidationAggregator();
        validationAggregator.addProfiles(profileClasses);
        this.validationMap = validationAggregator.getConcurrentValidationMap();
    }

    public ValidationExecutor(ConcurrentMap<EClassifier, CopyOnWriteArraySet<CachedValidator>> validationMap) {
        this.validationMap = validationMap;
    }

    public IStatus validate(EObject model) {
        return this.validate(model, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus validate(EObject model, IProgressMonitor monitor) {
        this.results.clear();
        try {
            int count = this.getModelObjectCount(model);
            monitor.beginTask("Validating objects", count / 1000 + 1);
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)model, (boolean)false);
            this.validateObject(model);
            int i = 0;
            while (iterator.hasNext()) {
                if (i++ % 1000 == 0) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                EObject next = (EObject)iterator.next();
                this.validateObject(next);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public List<ValidationDiagnostic> getResults() {
        return new ArrayList<ValidationDiagnostic>(this.results);
    }

    private int getModelObjectCount(EObject object) {
        int count = 1;
        TreeIterator iter = object.eAllContents();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    private void validateObject(EObject object) {
        if (object == null) {
            return;
        }
        Set validations = (Set)this.validationMap.get(object.eClass());
        if (validations == null) {
            return;
        }
        for (CachedValidator validator : validations) {
            ArrayList<ValidationDiagnostic> resultList = new ArrayList<ValidationDiagnostic>();
            try {
                validator.getValidatorInstance().validate(object, resultList);
            }
            catch (Exception ex) {
                this.addExceptionResult(object, validator.getValidatorClass(), ex);
                continue;
            }
            for (ValidationDiagnostic result : resultList) {
                result.setValidationID(validator.getValidationID());
                if (validator.getSeverity() != Severity.UNDEFINED) {
                    result.setSeverityLevel(validator.getSeverity());
                }
                this.results.add(result);
            }
        }
    }

    private void addExceptionResult(EObject object, Class<? extends IValidation> validatorClass, Exception ex) {
        ValidationDiagnostic exception = new ValidationDiagnostic("Validation exception in " + validatorClass + ": " + ex.getMessage(), object);
        exception.setValidationID("AM-Runtime-Exception");
        exception.setSeverityLevel(Severity.ERROR);
        this.results.add(exception);
    }

    public void dumpValidationMap(PrintStream out) {
        if (out == null) {
            return;
        }
        List classifiers = this.validationMap.keySet().stream().sorted(Comparator.comparing(ENamedElement::getName)).collect(Collectors.toList());
        for (EClassifier cl : classifiers) {
            out.println("Validations for " + cl.getName() + ":");
            for (CachedValidator vConf : (CopyOnWriteArraySet)this.validationMap.get(cl)) {
                out.println("    " + (Object)((Object)vConf.getSeverity()) + " - " + vConf.getValidationID());
            }
        }
    }

    public void dumpResultMap(PrintStream out) {
        if (out == null) {
            return;
        }
        Map<EObject, List<ValidationDiagnostic>> map = this.results.stream().collect(Collectors.groupingBy(ValidationDiagnostic::getTargetObject));
        out.println("Results (per object):");
        out.println(SEPARATOR);
        for (Map.Entry<EObject, List<ValidationDiagnostic>> entry : map.entrySet()) {
            out.println("EObject: " + entry.getKey());
            out.println(SEPARATOR);
            for (ValidationDiagnostic result : entry.getValue()) {
                out.println("  " + result.getValidationID() + " -- " + (Object)((Object)result.getSeverityLevel()));
                out.println("  " + result.getMessage());
                out.println(SEPARATOR);
            }
        }
    }
}

