/**
 * *******************************************************************************
 *  Copyright (c) 2021 Robert Bosch GmbH and others.
 * 
 *  This program and the accompanying materials are made
 *  available under the terms of the Eclipse Public License 2.0
 *  which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */

package org.eclipse.app4mc.amalthea.model.editor.providers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.app4mc.amalthea.model.presentation.ExtendedAmaltheaEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class DelegatingLabelProvider implements ILabelProvider {

	private ExtendedAmaltheaEditor editor;
	private ILabelProvider delegate;
	
	public DelegatingLabelProvider(ExtendedAmaltheaEditor editor, ILabelProvider delegate) {
		this.editor = editor;
		this.delegate = delegate;
	}

	public String getText(Object element) {
		final String text = delegate.getText(element);
		if (StringUtils.isBlank(text)) {
			return "???";
		}

		final String type = getTypeName(element);
		if (StringUtils.isBlank(type)) {
			return text;
		}

		String result = stripTypePrefix(text, type);
		
		if (editor.isShowTypesEnabled()) {
			result = result + " [" + type + "]";
		}

		return result;
	}

	private String getTypeName(Object element) {
		Object target = element;
		if (element instanceof IStructuredSelection) {
			target = ((IStructuredSelection) element).getFirstElement();
		}

		return (target instanceof EObject) ? ((EObject) target).eClass().getName() : null;
	}

	private String stripTypePrefix(final String text, final String type) {
		final String typeWithBlanks = StringUtils.join(StringUtils.splitByCharacterTypeCamelCase(type), ' ');
		return StringUtils.removeStart(text.trim(), typeWithBlanks + " ").trim();
	}

	public Image getImage(Object element) {
		return delegate.getImage(element);
	}

	public void dispose() {
		delegate.dispose();
		
		editor = null;
		delegate = null;
	}

	public void addListener(ILabelProviderListener listener) {
		delegate.addListener(listener);
	}


	public boolean isLabelProperty(Object element, String property) {
		return delegate.isLabelProperty(element, property);
	}

	public void removeListener(ILabelProviderListener listener) {
		delegate.removeListener(listener);
	}


}
