/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.amalthea.wizard;

import java.io.File;
import org.eclipse.app4mc.atdb._import.amalthea.wizard.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

class ImportPage
extends WizardResourceImportPage {
    private Text amxmiNameField;
    private Label atdbGroupLabel;
    private Text atdbNameField;
    private Button atdbBrowseButton;
    private Button updateExistingATDBFile;

    ImportPage(IStructuredSelection selection) {
        this("AMALTHEAImportPage", selection);
        this.setTitle(Messages.ImportPage_title);
        this.setMessage(Messages.ImportPage_message);
    }

    ImportPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label amxmiGroupLabel = new Label(sourceContainerGroup, 0);
        amxmiGroupLabel.setText(Messages.ImportPage_fromAmxmi);
        amxmiGroupLabel.setFont(parent.getFont());
        this.amxmiNameField = new Text(sourceContainerGroup, 2056);
        GridData amxmiData = new GridData(768);
        amxmiData.widthHint = 250;
        this.amxmiNameField.setLayoutData((Object)amxmiData);
        this.amxmiNameField.setFont(parent.getFont());
        Button amxmiBrowseButton = new Button(sourceContainerGroup, 8);
        amxmiBrowseButton.setText(IDEWorkbenchMessages.WizardImportPage_browse2);
        amxmiBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportPage.this.selectAMXMIFile();
                ImportPage.this.update();
            }
        });
        amxmiBrowseButton.setLayoutData((Object)new GridData(256));
        amxmiBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(amxmiBrowseButton);
        this.atdbGroupLabel = new Label(sourceContainerGroup, 0);
        this.atdbGroupLabel.setText(Messages.ImportPage_fromATDB);
        this.atdbGroupLabel.setFont(parent.getFont());
        this.atdbGroupLabel.setEnabled(false);
        this.atdbNameField = new Text(sourceContainerGroup, 2056);
        GridData atdbData = new GridData(768);
        atdbData.widthHint = 250;
        this.atdbNameField.setLayoutData((Object)atdbData);
        this.atdbNameField.setFont(parent.getFont());
        this.atdbNameField.setEnabled(false);
        this.atdbBrowseButton = new Button(sourceContainerGroup, 8);
        this.atdbBrowseButton.setText(IDEWorkbenchMessages.WizardImportPage_browse2);
        this.atdbBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportPage.this.selectATDBFile();
                ImportPage.this.update();
            }
        });
        this.atdbBrowseButton.setLayoutData((Object)new GridData(256));
        this.atdbBrowseButton.setFont(parent.getFont());
        this.atdbBrowseButton.setEnabled(false);
        this.setButtonLayoutData(this.atdbBrowseButton);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.updateExistingATDBFile = new Button((Composite)optionsGroup, 32);
        this.updateExistingATDBFile.setFont(optionsGroup.getFont());
        this.updateExistingATDBFile.setText(Messages.ImportPage_optionUpdateATDB);
        this.updateExistingATDBFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ImportPage.this.update();
            }
        });
    }

    protected ITreeContentProvider getFileProvider() {
        return null;
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    protected boolean determinePageCompletion() {
        boolean result = super.determinePageCompletion();
        String amxmiPath = this.amxmiNameField.getText();
        File amxmiFile = new File(amxmiPath);
        result &= amxmiFile.exists();
        if (this.updateExistingATDBFile != null && this.updateExistingATDBFile.getSelection()) {
            String atdbPath = this.atdbNameField.getText();
            File atdbFile = new File(atdbPath);
            result &= atdbFile.exists();
        }
        return result;
    }

    private void selectAMXMIFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(Messages.ImportPage_selectFile);
        fileDialog.setFilterExtensions(new String[]{"*.amxmi"});
        String open = fileDialog.open();
        if (open != null) {
            this.amxmiNameField.setText(open);
            this.update();
        }
    }

    private void selectATDBFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(Messages.ImportPage_selectFile);
        fileDialog.setFilterExtensions(new String[]{"*.atdb"});
        String open = fileDialog.open();
        if (open != null) {
            this.atdbNameField.setText(open);
            this.update();
        }
    }

    private void update() {
        this.setPageComplete(this.determinePageCompletion());
        this.atdbGroupLabel.setEnabled(this.updateExistingATDBFile.getSelection());
        this.atdbBrowseButton.setEnabled(this.updateExistingATDBFile.getSelection());
        this.atdbNameField.setEnabled(this.updateExistingATDBFile.getSelection());
    }

    String getAMXMISource() {
        return this.amxmiNameField.getText();
    }

    String getATDBSource() {
        return this.atdbNameField.getText();
    }

    IContainer getTargetContainer() {
        return this.getSpecifiedContainer();
    }

    boolean isUpdateExistingATDB() {
        return this.updateExistingATDBFile.getSelection();
    }
}

