/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf.wizard;

import java.io.File;
import org.eclipse.app4mc.atdb._import.btf.wizard.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

class ImportPage
extends WizardResourceImportPage {
    private Text sourceNameField;
    private Button persistTraceEvents;

    ImportPage(IStructuredSelection selection) {
        this("btfImportPage", selection);
        this.setTitle(Messages.ImportPage_title);
        this.setMessage(Messages.ImportPage_message);
    }

    ImportPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(Messages.ImportPage_fromBTF);
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Text(sourceContainerGroup, 2056);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        Button sourceBrowseButton = new Button(sourceContainerGroup, 8);
        sourceBrowseButton.setText(IDEWorkbenchMessages.WizardImportPage_browse2);
        sourceBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportPage.this.selectFile();
                ImportPage.this.update();
            }
        });
        sourceBrowseButton.setLayoutData((Object)new GridData(256));
        sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(sourceBrowseButton);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.persistTraceEvents = new Button((Composite)optionsGroup, 32);
        this.persistTraceEvents.setFont(optionsGroup.getFont());
        this.persistTraceEvents.setText(Messages.ImportPage_optionPersistTraceEvents);
        this.persistTraceEvents.setSelection(true);
    }

    protected ITreeContentProvider getFileProvider() {
        return null;
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    protected boolean determinePageCompletion() {
        boolean result = super.determinePageCompletion();
        String path = this.sourceNameField.getText();
        File file = new File(path);
        return result &= file.exists();
    }

    private void selectFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(Messages.ImportPage_selectFile);
        fileDialog.setFilterExtensions(new String[]{"*.btf"});
        String open = fileDialog.open();
        if (open != null) {
            this.sourceNameField.setText(open);
            this.update();
        }
    }

    private void update() {
        this.setPageComplete(this.determinePageCompletion());
    }

    String getSource() {
        return this.sourceNameField.getText();
    }

    IContainer getTargetContainer() {
        return this.getSpecifiedContainer();
    }

    boolean isPersistTraceEvents() {
        return this.persistTraceEvents.getSelection();
    }
}

