/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.misc;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.Algorithm;
import org.eclipse.app4mc.amalthea.model.Grouping;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="AM-Mapping-Scheduler-ProcessingUnit", checks={"A scheduler should be responsible for at least one processing unit"})
public class AmMappingSchedulerProcessingUnit
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getScheduler();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof Scheduler) {
            Scheduler sched = (Scheduler)object;
            Algorithm algo = sched.getSchedulingAlgorithm();
            if (algo instanceof Grouping) {
                return;
            }
            EList allocations = sched.getSchedulerAllocations();
            if (allocations.isEmpty()) {
                this.addIssue(results, (EObject)sched, null, "Scheduler not responsible for any core: " + this.name((INamed)sched));
            }
        }
    }
}

