/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea._import.atdb.AConverter;
import org.eclipse.app4mc.amalthea._import.atdb.AmaltheaModelUtil;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainContainer;
import org.eclipse.app4mc.amalthea.model.EventChainItemType;
import org.eclipse.app4mc.amalthea.model.EventChainReference;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public class EventChainConverter
extends AConverter {
    public EventChainConverter(Amalthea model, ATDBConnection con) {
        super(model, con, "event chains");
    }

    @Override
    protected void execute() throws SQLException {
        ConstraintsModel constrModel = ModelUtil.getOrCreateConstraintsModel((Amalthea)this.model);
        ArrayList eventChains = new ArrayList();
        this.con.getAllEventChains().forEach(ecName -> {
            EventChain eventChain = AmaltheaModelUtil.getOrAddNew((EObject)constrModel, AmaltheaPackage.eINSTANCE.getConstraintsModel_EventChains(), ecName, EventChain.class, AmaltheaPackage.eINSTANCE.getEventChain());
            eventChains.add(eventChain);
        });
        for (EventChain eventChain : eventChains) {
            String responseEventName;
            String stimulusEventName = this.con.getEventChainStimulus(eventChain.getName());
            if (stimulusEventName.length() > 0) {
                AmaltheaModelUtil.getOrAddNew((EObject)eventChain, AmaltheaPackage.eINSTANCE.getAbstractEventChain_Stimulus(), stimulusEventName, Event.class);
            }
            if ((responseEventName = this.con.getEventChainResponse(eventChain.getName())).length() > 0) {
                AmaltheaModelUtil.getOrAddNew((EObject)eventChain, AmaltheaPackage.eINSTANCE.getAbstractEventChain_Response(), responseEventName, Event.class);
            }
            List items = this.con.getEventChainItems(eventChain.getName());
            for (String subECName : items) {
                boolean isReference;
                if (subECName.length() == 0) continue;
                boolean bl = isReference = !AmaltheaIndex.getElements((Notifier)constrModel, (String)subECName, EventChain.class).isEmpty();
                if (isReference) {
                    AmaltheaModelUtil.getOrAddNewWithContainer((EObject)eventChain, AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EventChainReference.class, AmaltheaPackage.eINSTANCE.getEventChainReference(), AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), EventChain.class, AmaltheaPackage.eINSTANCE.getEventChain(), subECName);
                    continue;
                }
                AmaltheaModelUtil.getOrAddNewWithContainer((EObject)eventChain, AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EventChainContainer.class, AmaltheaPackage.eINSTANCE.getEventChainContainer(), AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), SubEventChain.class, AmaltheaPackage.eINSTANCE.getSubEventChain(), subECName);
            }
            int minItemsComplete = this.con.getEventChainMinItemsCompleted(eventChain.getName());
            if (minItemsComplete > 0) {
                eventChain.setMinItemsCompleted(minItemsComplete);
                eventChain.setItemType(EventChainItemType.PARALLEL);
                continue;
            }
            eventChain.setItemType(EventChainItemType.SEQUENCE);
        }
    }
}

