/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.provider;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

public class AmaltheaItemProviderAdapter
extends ItemProviderAdapter {
    public AmaltheaItemProviderAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        if (!(feature instanceof EStructuralFeature) || !(child instanceof EObject)) {
            return super.getCreateChildText(owner, feature, child, selection);
        }
        EStructuralFeature childFeature = (EStructuralFeature)feature;
        Object childObject = child;
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)childFeature)) {
            FeatureMap.Entry entry = (FeatureMap.Entry)child;
            childFeature = entry.getEStructuralFeature();
            childObject = entry.getValue();
        }
        String featureText = this.getFeatureText2(childFeature);
        String childTypeText = this.getTypeText(childObject);
        if (childFeature instanceof EAttribute) {
            return this.getTypeText((EAttribute)childFeature);
        }
        if (this.menuHasManyActions(childFeature, owner)) {
            return String.valueOf(featureText) + " | " + childTypeText;
        }
        if (featureText.equals(childTypeText)) {
            return childTypeText;
        }
        if (childFeature.isMany()) {
            String trimmedType = childTypeText;
            if (childTypeText.toUpperCase().startsWith("HW ") || childTypeText.toUpperCase().startsWith("OS ")) {
                trimmedType = childTypeText.substring(3);
            }
            String substring = trimmedType.substring(0, trimmedType.length() - 1);
            if (featureText.toLowerCase().startsWith(substring.toLowerCase())) {
                return trimmedType;
            }
        }
        return featureText;
    }

    private String getFeatureText2(EStructuralFeature feature) {
        String text = this.getFeatureText(feature);
        if (text.equals("Entries")) {
            return "Entry";
        }
        if (text.equals("Stimuli")) {
            return "Stimulus";
        }
        if (text.endsWith("Items") || text.endsWith("Values") || text.endsWith("Requirements") || text.endsWith("Constraints") || text.endsWith("Definitions") || text.endsWith("Domains") || text.endsWith("Components") || text.endsWith("Systems") || text.endsWith("Modules") || text.endsWith("Clocks") || text.endsWith("Events")) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    private boolean menuHasManyActions(EStructuralFeature feature, Object owner) {
        BasicEList newChildDescriptors = new BasicEList();
        this.collectNewChildDescriptors((Collection)newChildDescriptors, owner);
        int counter = 0;
        for (Object obj : newChildDescriptors) {
            CommandParameter comParam;
            if (!(obj instanceof CommandParameter) || !feature.equals((comParam = (CommandParameter)obj).getEStructuralFeature()) || ++counter <= 1) continue;
            return true;
        }
        return false;
    }
}

