/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.hw;

import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.visualization.hw.templates.HWBlockGenerator;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=HW Structure Block Diagram", "description=Block Diagram Visualization for Hardware Structures"})
public class HWBlockDiagramVisualization2
implements Visualization {
    @PostConstruct
    public void createVisualization(List<HwStructure> structures, Composite parent, Shell shell) {
        PlantUmlDiagram diagram = new PlantUmlDiagram();
        Browser browser = new Browser(parent, 0);
        new Thread(() -> {
            String result;
            HWBlockGenerator.updateDiagram(diagram, structures);
            try {
                result = diagram.renderToSvg();
            }
            catch (IOException e) {
                result = this.prepareErrorMessage(e);
                Platform.getLog(HWBlockDiagramVisualization2.class).error(result, (Throwable)e);
            }
            if (result != null && !browser.isDisposed()) {
                String browserContent = result;
                browser.getDisplay().asyncExec(() -> {
                    if (!browser.isDisposed()) {
                        browser.setText(browserContent);
                    }
                });
            }
        }).start();
    }

    private String prepareErrorMessage(IOException e) {
        return "Error invoking PlantUML: \"" + e.getMessage() + "\". Make sure you have configured the path to the dot executable properly in the PlantUML preferences.";
    }
}

