/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.util.svg;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

abstract class AbstractDiagram {
    private StringBuilder diagramBuilder = new StringBuilder();
    private BiMap<Object, String> idMap = HashBiMap.create();

    AbstractDiagram() {
    }

    public void resetDiagramData() {
        this.diagramBuilder = new StringBuilder();
        this.idMap = HashBiMap.create();
    }

    public void append(CharSequence chars) {
        this.diagramBuilder.append(chars);
    }

    public void append(String str) {
        this.diagramBuilder.append(str);
    }

    public void appendId(Object obj) {
        this.diagramBuilder.append(this.getOrCreateId(obj));
    }

    public void appendUrl(Object obj) {
        this.diagramBuilder.append(", URL=\"#" + this.getOrCreateId(obj) + "\"");
    }

    public String getDiagramText() {
        return this.diagramBuilder.toString();
    }

    public String getOrCreateId(Object obj) {
        return (String)this.idMap.computeIfAbsent(obj, k -> "obj" + this.idMap.size());
    }

    public Object getObjectById(String id) {
        return this.idMap.inverse().get((Object)id);
    }

    public String getGraphvizPath() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sourceforge.plantuml.eclipse");
        String dotPath1 = prefs.get("graphvizPath", null);
        if (dotPath1 != null && !dotPath1.isEmpty()) {
            return dotPath1;
        }
        String dotPath2 = System.getenv("GRAPHVIZ_DOT");
        if (dotPath2 != null && !dotPath2.isEmpty()) {
            return dotPath2;
        }
        if (Platform.getOS().equals("win32")) {
            return "dot.exe";
        }
        return "dot";
    }
}

