/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.constraints;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.EventChainLatencyConstraint;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Constraints-ECLConstraint", checks={"Maximum must not be smaller than minimum"})
public class TAConstraintsECLConstraint
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getEventChainLatencyConstraint();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof EventChainLatencyConstraint) {
            EventChainLatencyConstraint eclc = (EventChainLatencyConstraint)eObject;
            Time minimum = eclc.getMinimum();
            Time maximum = eclc.getMaximum();
            if (maximum != null && minimum != null && minimum.compareTo(maximum) > 0) {
                this.addIssue(results, (EObject)eclc, (EStructuralFeature)ePackage.getEventChainLatencyConstraint_Minimum(), "The minimum is greater than the maximum (" + minimum + " > " + maximum + ", in " + this.objectInfo((EObject)eclc) + ")");
            }
        }
    }
}

