/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters094.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.3", "output_model_version=0.9.4"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final String MODE = "mode";
    private static final String MODE_VALUE = "modeValue";
    private static final String INITIAL_VALUE = "initialValue";
    private static final String AM = "am";
    private static final String XSI = "xsi";
    private static final String HREF = "href";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String AMLT_PREFIX = "amlt:/#";
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.9.3 to 0.9.4 : Executing Sw converter for model file : {0}", new Object[]{targetFile.getName()});
        Document document = filename2documentMap.get(targetFile);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateRunnables(rootElement);
        this.updateDatatypes(rootElement);
        this.updateModeLabels(rootElement);
        this.updateModeLabelAccesses(rootElement);
        this.updateModeValueLists(rootElement);
        this.updateModeConditions(rootElement);
        this.updateEnablingModeValueLists(rootElement);
    }

    private void updateDatatypes(Element rootElement) {
        String xpath = "./swModel/typeDefinitions[@xsi:type=\"am:BaseTypeDefinition\"]";
        List types = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/typeDefinitions[@xsi:type=\"am:BaseTypeDefinition\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element baseType : types) {
            for (Element mapping : baseType.getChildren("dataMapping")) {
                String platformName = mapping.getAttributeValue("platformName");
                String platformType = mapping.getAttributeValue("platformType");
                mapping.removeAttribute("platformName");
                mapping.removeAttribute("platformType");
                mapping.setName("aliases");
                mapping.setAttribute("target", platformName);
                mapping.setAttribute("alias", platformType);
            }
        }
    }

    private void updateRunnables(Element rootElement) {
        String xpath = "./swModel/runnables";
        String deadlineXpath = "./swModel/runnables/deadline";
        List runnables = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        List deadlines = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables/deadline", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        Element constraintModel = rootElement.getChild("constraintsModel");
        if (constraintModel == null && !deadlines.isEmpty()) {
            constraintModel = new Element("constraintsModel");
            rootElement.addContent((Content)constraintModel);
        }
        if (constraintModel != null) {
            for (Element runnable : runnables) {
                Element deadline = runnable.getChild("deadline");
                String runnableName = runnable.getAttributeValue(NAME);
                if (deadline == null) continue;
                Element runnableReq = new Element("requirements");
                constraintModel.addContent((Content)runnableReq);
                runnableReq.setAttribute(TYPE, "am:RunnableRequirement", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                runnableReq.setAttribute(NAME, "deadline");
                runnableReq.setAttribute("runnable", String.valueOf(HelperUtil.encodeName((String)runnableName)) + "?type=Runnable");
                Element limit = new Element("limit");
                runnableReq.addContent((Content)limit);
                limit.setAttribute(TYPE, "am:TimeRequirementLimit", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                limit.setAttribute("limitType", "UpperLimit");
                limit.setAttribute("metric", "ResponseTime");
                Element limitValue = deadline.clone();
                limitValue.setName("limitValue");
                limit.addContent((Content)limitValue);
                runnable.removeContent((Content)deadline);
            }
        }
    }

    private void updateModeLabels(Element rootElement) {
        String xpath = "./swModel/modes";
        List modes = HelperUtil.getXpathResult((Element)rootElement, (String)xpath, Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element mode : modes) {
            mode.setAttribute(TYPE, "am:EnumMode", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        }
        xpath = "./swModel/modeLabels";
        List modeLabels = HelperUtil.getXpathResult((Element)rootElement, (String)xpath, Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element modeLabel : modeLabels) {
            String[] split;
            String hrefValue;
            Element element;
            String[] split2;
            String attributeValue = modeLabel.getAttributeValue(INITIAL_VALUE);
            if (attributeValue != null && (split2 = this.extractModeAndLiteral(attributeValue)).length == 2) {
                String mode = split2[0];
                String literal = HelperUtil.decodeName((String)split2[1]);
                modeLabel.setAttribute(MODE, String.valueOf(mode) + "?type=EnumMode");
                modeLabel.setAttribute(INITIAL_VALUE, literal);
            }
            if ((element = this.getSingleChild(modeLabel, INITIAL_VALUE)) == null || (hrefValue = element.getAttributeValue(HREF)) == null || (split = this.extractModeAndLiteral(hrefValue)).length != 2) continue;
            String mode = split[0];
            String literal = HelperUtil.decodeName((String)split[1]);
            element.setName(MODE);
            element.setAttribute(TYPE, "am:EnumMode", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            element.setAttribute(HREF, AMLT_PREFIX + mode + "?type=EnumMode");
            modeLabel.setAttribute(INITIAL_VALUE, literal);
        }
    }

    private void updateModeLabelAccesses(Element rootElement) {
        String xpath = "./swModel/runnables//*[@xsi:type=\"am:ModeLabelAccess\"]";
        List modeLabelAccesses = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables//*[@xsi:type=\"am:ModeLabelAccess\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element modeLabelAccess : modeLabelAccesses) {
            String hrefValue;
            Element element;
            Attribute modeValue;
            Attribute access = modeLabelAccess.getAttribute("access");
            if (access != null && "write".equals(access.getValue())) {
                access.setValue("set");
            }
            if ((modeValue = modeLabelAccess.getAttribute(MODE_VALUE)) != null) {
                modeValue.setName(VALUE);
                modeValue.setValue(this.extractAndDecodeLiteral(modeValue.getValue()));
            }
            if ((element = this.getSingleChild(modeLabelAccess, MODE_VALUE)) == null || (hrefValue = element.getAttributeValue(HREF)) == null) continue;
            modeLabelAccess.setAttribute(VALUE, this.extractAndDecodeLiteral(hrefValue));
            modeLabelAccess.removeChild(MODE_VALUE);
        }
    }

    private void updateModeValueLists(Element rootElement) {
        String xpath = "./stimuliModel/stimuli/setModeValueList/entries";
        List assignments = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/stimuli/setModeValueList/entries", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element assignment : assignments) {
            this.convertModeValueContents(assignment);
        }
    }

    private void updateModeConditions(Element rootElement) {
        String xpath = "./swModel/runnables//*[@xsi:type=\"am:RunnableModeSwitch\"]/entries/condition/entries|./swModel/tasks//*[@xsi:type=\"am:ModeSwitch\"]/entries/condition/entries|./stimuliModel/stimuli/enablingModeValueList/entries";
        List conditionDisjunctionEntries = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables//*[@xsi:type=\"am:RunnableModeSwitch\"]/entries/condition/entries|./swModel/tasks//*[@xsi:type=\"am:ModeSwitch\"]/entries/condition/entries|./stimuliModel/stimuli/enablingModeValueList/entries", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element disjunctionEntry : conditionDisjunctionEntries) {
            String entryType = disjunctionEntry.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            if ("am:ModeValue".equals(entryType)) {
                this.convertModeValue(disjunctionEntry, true);
                continue;
            }
            if (!"am:ModeValueConjunction".equals(entryType)) continue;
            disjunctionEntry.setAttribute(TYPE, "am:ModeConditionConjunction", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            for (Element modeValue : disjunctionEntry.getChildren("entries")) {
                this.convertModeValue(modeValue, false);
            }
        }
    }

    private void convertModeValue(Element modeValueElement, boolean setType) {
        if (setType) {
            modeValueElement.setAttribute(TYPE, "am:ModeCondition", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        }
        modeValueElement.setAttribute("relation", "EQUAL");
        this.convertModeValueContents(modeValueElement);
    }

    private void convertModeValueContents(Element modeValueElement) {
        String hrefValue;
        Element valueElement;
        String refValue;
        Element providerElement;
        Attribute providerAttribute = modeValueElement.getAttribute("valueProvider");
        if (providerAttribute != null) {
            providerAttribute.setName("label");
        }
        if ((providerElement = this.getSingleChild(modeValueElement, "valueProvider")) != null) {
            providerElement.setName("label");
        }
        if ((refValue = modeValueElement.getAttributeValue(VALUE)) != null) {
            modeValueElement.setAttribute(VALUE, this.extractAndDecodeLiteral(refValue));
        }
        if ((valueElement = this.getSingleChild(modeValueElement, VALUE)) != null && (hrefValue = valueElement.getAttributeValue(HREF)) != null) {
            modeValueElement.setAttribute(VALUE, this.extractAndDecodeLiteral(hrefValue));
            modeValueElement.removeChild(VALUE);
        }
    }

    private void updateEnablingModeValueLists(Element rootElement) {
        String xpath = "./stimuliModel/stimuli";
        List stimuli = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/stimuli", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_094, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element stimulus : stimuli) {
            Element disablingList;
            String stimulusName = stimulus.getAttributeValue(NAME);
            Element enablingList = this.getSingleChild(stimulus, "enablingModeValueList");
            if (enablingList != null) {
                enablingList.setName("executionCondition");
            }
            if ((disablingList = this.getSingleChild(stimulus, "disablingModeValueList")) == null) continue;
            this.logger.warn("From Stimulus : {0}, disablingModeValueList element is removed (as this element is no longer supported by AMALTHEA meta model from 0.9.4 version) ", new Object[]{stimulusName});
            stimulus.removeChild("disablingModeValueList");
        }
    }

    private String[] extractModeAndLiteral(String modeValueRef) {
        String trimmed = HelperUtil.trimStartAndEnd((String)modeValueRef, (String)AMLT_PREFIX, (String)"?type=ModeLiteral");
        return trimmed.split("/");
    }

    private String extractAndDecodeLiteral(String modeValueRef) {
        String[] split = this.extractModeAndLiteral(modeValueRef);
        if (split.length == 2) {
            return HelperUtil.decodeName((String)split[1]);
        }
        return modeValueRef;
    }

    private Element getSingleChild(Element parent, String name) {
        List list = parent.getChildren(name);
        if (list.size() == 1) {
            return (Element)list.get(0);
        }
        return null;
    }
}

