/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ContinuousValueInterval;
import org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics;
import org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueInterval;
import org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics;
import org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.EnumMode;
import org.eclipse.app4mc.amalthea.model.ILocalModeValueSource;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.LocalModeLabel;
import org.eclipse.app4mc.amalthea.model.LocalModeValue;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.Mode;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.ModeLabelAssignment;
import org.eclipse.app4mc.amalthea.model.ModeLabelCondition;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.NumericMode;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeInterval;
import org.eclipse.app4mc.amalthea.model.TimeStatistics;
import org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.TruncatedContinuousValueDistribution;
import org.eclipse.app4mc.amalthea.model.TruncatedDiscreteValueDistribution;
import org.eclipse.app4mc.amalthea.model.TruncatedTimeDistribution;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;

public class AmaltheaValidations {
    private static final String DIAGNOSTIC_SOURCE = "org.eclipse.app4mc.amalthea.model";
    private static final int NO_INDEX = -1;
    private static final AmaltheaPackage PACKAGE = AmaltheaPackage.eINSTANCE;

    private AmaltheaValidations() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean validateInvariants(MinAvgMaxStatistic obj, DiagnosticChain diagnostics) {
        boolean isValid;
        boolean bl = isValid = (float)obj.getMin() <= obj.getAvg() && obj.getAvg() <= (float)obj.getMax();
        if (!isValid) {
            AmaltheaValidations.addError(obj, (EStructuralFeature)PACKAGE.getMinAvgMaxStatistic_Avg(), "MinAvgMaxStatistic: constraint min <= avg <= max violated", diagnostics);
        }
        return isValid;
    }

    public static boolean validateInvariants(TimeInterval obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, obj.getLowerBound(), AmaltheaValidations.getAverage(obj), obj.getUpperBound());
    }

    public static boolean validateInvariants(DiscreteValueInterval obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, AmaltheaValidations.toDouble(obj.getLowerBound()), AmaltheaValidations.getAverage(obj), AmaltheaValidations.toDouble(obj.getUpperBound()));
    }

    public static boolean validateInvariants(ContinuousValueInterval obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, obj.getLowerBound(), AmaltheaValidations.getAverage(obj), obj.getUpperBound());
    }

    public static boolean validateInvariants(TruncatedTimeDistribution obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, obj.getLowerBound(), null, obj.getUpperBound());
    }

    public static boolean validateInvariants(TruncatedDiscreteValueDistribution obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, AmaltheaValidations.toDouble(obj.getLowerBound()), null, AmaltheaValidations.toDouble(obj.getUpperBound()));
    }

    public static boolean validateInvariants(TruncatedContinuousValueDistribution obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkMinAvgMax(obj, diagnostics, obj.getLowerBound(), null, obj.getUpperBound());
    }

    /*
     * WARNING - void declaration
     */
    private static Time getAverage(TimeInterval obj) {
        TimeInterval timeInterval;
        Time avg = null;
        TimeInterval timeInterval2 = obj;
        if (timeInterval2 instanceof TimeStatistics) {
            void timeStatistics;
            TimeStatistics timeStatistics2 = (TimeStatistics)timeInterval2;
            TimeStatistics cfr_ignored_0 = (TimeStatistics)timeInterval2;
            avg = timeStatistics.getAverage();
        }
        if ((timeInterval = obj) instanceof TimeWeibullEstimatorsDistribution) {
            void timeWeibullDist;
            TimeWeibullEstimatorsDistribution timeWeibullEstimatorsDistribution = (TimeWeibullEstimatorsDistribution)timeInterval;
            TimeWeibullEstimatorsDistribution cfr_ignored_1 = (TimeWeibullEstimatorsDistribution)timeInterval;
            avg = timeWeibullDist.getAverage();
        }
        return avg;
    }

    /*
     * WARNING - void declaration
     */
    private static Double getAverage(DiscreteValueInterval obj) {
        DiscreteValueInterval discreteValueInterval;
        Double avg = null;
        DiscreteValueInterval discreteValueInterval2 = obj;
        if (discreteValueInterval2 instanceof DiscreteValueStatistics) {
            void discValStatistics;
            DiscreteValueStatistics discreteValueStatistics = (DiscreteValueStatistics)discreteValueInterval2;
            DiscreteValueStatistics cfr_ignored_0 = (DiscreteValueStatistics)discreteValueInterval2;
            avg = discValStatistics.getAverage();
        }
        if ((discreteValueInterval = obj) instanceof DiscreteValueWeibullEstimatorsDistribution) {
            void discValWeibullDist;
            DiscreteValueWeibullEstimatorsDistribution discreteValueWeibullEstimatorsDistribution = (DiscreteValueWeibullEstimatorsDistribution)discreteValueInterval;
            DiscreteValueWeibullEstimatorsDistribution cfr_ignored_1 = (DiscreteValueWeibullEstimatorsDistribution)discreteValueInterval;
            avg = discValWeibullDist.getAverage();
        }
        return avg;
    }

    /*
     * WARNING - void declaration
     */
    private static Double getAverage(ContinuousValueInterval obj) {
        ContinuousValueInterval continuousValueInterval;
        Double avg = null;
        ContinuousValueInterval continuousValueInterval2 = obj;
        if (continuousValueInterval2 instanceof ContinuousValueStatistics) {
            void contValStatistics;
            ContinuousValueStatistics continuousValueStatistics = (ContinuousValueStatistics)continuousValueInterval2;
            ContinuousValueStatistics cfr_ignored_0 = (ContinuousValueStatistics)continuousValueInterval2;
            avg = contValStatistics.getAverage();
        }
        if ((continuousValueInterval = obj) instanceof ContinuousValueWeibullEstimatorsDistribution) {
            void contValWeibullDist;
            ContinuousValueWeibullEstimatorsDistribution continuousValueWeibullEstimatorsDistribution = (ContinuousValueWeibullEstimatorsDistribution)continuousValueInterval;
            ContinuousValueWeibullEstimatorsDistribution cfr_ignored_1 = (ContinuousValueWeibullEstimatorsDistribution)continuousValueInterval;
            avg = contValWeibullDist.getAverage();
        }
        return avg;
    }

    private static Double toDouble(Long value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    private static <T extends Comparable<T>> boolean checkMinAvgMax(EObject obj, DiagnosticChain diagnostics, T min, T avg, T max) {
        boolean isValid = true;
        if (min != null && max != null && min.compareTo(max) > 0) {
            AmaltheaValidations.addError(obj, null, String.valueOf(obj.eClass().getName()) + ": lower bound > upper bound", diagnostics);
            isValid = false;
        }
        if (min != null && avg != null && min.compareTo(avg) > 0) {
            AmaltheaValidations.addError(obj, null, String.valueOf(obj.eClass().getName()) + ": lower bound > average", diagnostics);
            isValid = false;
        }
        if (avg != null && max != null && avg.compareTo(max) > 0) {
            AmaltheaValidations.addError(obj, null, String.valueOf(obj.eClass().getName()) + ": average > upper bound", diagnostics);
            isValid = false;
        }
        return isValid;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static boolean validateInvariants(IReferable obj, DiagnosticChain diagnostics) {
        String shortName = obj.getName();
        if (shortName == null || shortName.isEmpty()) {
            AmaltheaValidations.addError(obj, (EStructuralFeature)PACKAGE.getINamed_Name(), String.valueOf(obj.eClass().getName()) + ": missing name", diagnostics);
            return false;
        }
        Set<@NonNull ?> duplicates = AmaltheaIndex.getElements((Notifier)obj, shortName, obj.getClass());
        if (duplicates.size() > 1) {
            String longName = obj.getQualifiedName();
            if (duplicates.stream().anyMatch(e -> e != obj && longName.equals(e.getQualifiedName()))) {
                AmaltheaValidations.addError(obj, (EStructuralFeature)PACKAGE.getINamed_Name(), String.valueOf(obj.eClass().getName()) + ": duplicate name", diagnostics);
                return false;
            }
        }
        return true;
    }

    public static boolean validateInvariants(LocalModeLabel obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkModeAndValue(obj, (EStructuralFeature)PACKAGE.getLocalModeLabel_DefaultValue(), obj.getMode(), obj.getDefaultValue(), diagnostics);
    }

    public static boolean validateInvariants(LocalModeValue obj, DiagnosticChain diagnostics) {
        if (obj.getLabel() != null && obj.getValueSource() != null) {
            LocalModeLabel label = obj.getLabel();
            ILocalModeValueSource source = obj.getValueSource();
            if (label.isEnum() && source.isNumeric() || label.isNumeric() && source.isEnum()) {
                AmaltheaValidations.addError(obj, (EStructuralFeature)PACKAGE.getLocalModeValue_ValueSource(), String.valueOf(obj.eClass().getName()) + ": incompatible types", diagnostics);
                return false;
            }
            return AmaltheaValidations.checkModeCompatibility(obj, (EStructuralFeature)PACKAGE.getLocalModeValue_ValueSource(), label.getMode(), source.getMode(), diagnostics);
        }
        return true;
    }

    public static boolean validateInvariants(ModeLabel obj, DiagnosticChain diagnostics) {
        return AmaltheaValidations.checkModeAndValue(obj, (EStructuralFeature)PACKAGE.getModeLabel_InitialValue(), obj.getMode(), obj.getInitialValue(), diagnostics);
    }

    public static boolean validateInvariants(ModeValue obj, DiagnosticChain diagnostics) {
        ModeLabel modeLabel = obj.getLabel();
        if (modeLabel == null) {
            return false;
        }
        return AmaltheaValidations.checkModeAndValue(obj, (EStructuralFeature)PACKAGE.getModeValue_Value(), modeLabel.getMode(), obj.getValue(), diagnostics);
    }

    public static boolean validateInvariants(ModeLabelAccess obj, DiagnosticChain diagnostics) {
        ModeLabel modeLabel = obj.getData();
        if (modeLabel == null) {
            return false;
        }
        if (obj.getAccess() == ModeLabelAccessEnum.SET) {
            return AmaltheaValidations.checkModeAndValue(obj, (EStructuralFeature)PACKAGE.getModeLabelAccess_Value(), modeLabel.getMode(), obj.getValue(), diagnostics);
        }
        return true;
    }

    public static boolean validateInvariants(ModeLabelAssignment obj, DiagnosticChain diagnostics) {
        if (obj.getGlobalLabel() != null && obj.getLocalLabel() != null) {
            ModeLabel label1 = obj.getGlobalLabel();
            LocalModeLabel label2 = obj.getLocalLabel();
            return AmaltheaValidations.checkModeCompatibility(obj, (EStructuralFeature)PACKAGE.getModeLabelAssignment_LocalLabel(), label1.getMode(), label2.getMode(), diagnostics);
        }
        return true;
    }

    public static boolean validateInvariants(ModeLabelCondition obj, DiagnosticChain diagnostics) {
        if (obj.getLabel1() != null && obj.getLabel2() != null) {
            ModeLabel label1 = obj.getLabel1();
            ModeLabel label2 = obj.getLabel2();
            return AmaltheaValidations.checkModeCompatibility(obj, (EStructuralFeature)PACKAGE.getModeLabelAssignment_LocalLabel(), label1.getMode(), label2.getMode(), diagnostics);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkModeAndValue(EObject obj, EStructuralFeature feature, Mode mode, String value, DiagnosticChain diagnostics) {
        boolean isInteger;
        if (mode == null) {
            AmaltheaValidations.addWarning(obj, feature, String.valueOf(obj.eClass().getName()) + ": unknown value type (mode)", diagnostics);
            return false;
        }
        if (value == null) {
            if (feature.getLowerBound() != 0) {
                AmaltheaValidations.addError(obj, feature, String.valueOf(obj.eClass().getName()) + ": missing value", diagnostics);
                return false;
            }
            return true;
        }
        String trimmedValue = value.trim();
        Mode mode2 = mode;
        if (mode2 instanceof EnumMode) {
            void enumMode;
            EnumMode enumMode2 = (EnumMode)mode2;
            EnumMode cfr_ignored_0 = (EnumMode)mode2;
            if (enumMode.getLiteral(trimmedValue) == null) {
                AmaltheaValidations.addError(obj, feature, "The " + feature.getName() + " '" + trimmedValue + "' is not a valid literal of Enum Mode \"" + mode.getName() + "\"", diagnostics);
                return false;
            }
        }
        if (mode instanceof NumericMode && !(isInteger = trimmedValue.matches("-?\\d+"))) {
            AmaltheaValidations.addError(obj, feature, "The " + feature.getName() + " '" + trimmedValue + "' is not an integer", diagnostics);
            return false;
        }
        return true;
    }

    private static boolean checkModeCompatibility(EObject obj, EStructuralFeature feature, Mode mode1, Mode mode2, DiagnosticChain diagnostics) {
        if (mode1 != null && mode2 != null && !mode1.equals(mode2)) {
            AmaltheaValidations.addError(obj, feature, String.valueOf(obj.eClass().getName()) + ": incompatible modes", diagnostics);
            return false;
        }
        return true;
    }

    private static void addWarning(EObject object, EStructuralFeature feature, String message, DiagnosticChain diagnostics) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)AmaltheaValidations.createIssue(2, object, feature, message));
        }
    }

    private static void addError(EObject object, EStructuralFeature feature, String message, DiagnosticChain diagnostics) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)AmaltheaValidations.createIssue(4, object, feature, message));
        }
    }

    private static BasicDiagnostic createIssue(int severity, EObject object, EStructuralFeature feature, String message) {
        return new BasicDiagnostic(severity, DIAGNOSTIC_SOURCE, -1, message, new Object[]{object, feature});
    }
}

