/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ListObject;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.impl.SchedulingParameterImpl;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-OS-Scheduling-Parameter-Value-Type-Matches-Defined-Type", checks={"The type of the specified scheduling parameter must match the type defined in the scheduling parameter definition"})
public class AmOSSchedulingParameterValueTypeMatchesDefinedType
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getSchedulingParameter();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject object, List<ValidationDiagnostic> results) {
        EObject eObject = object;
        if (eObject instanceof SchedulingParameterImpl) {
            void sp;
            SchedulingParameterImpl schedulingParameterImpl = (SchedulingParameterImpl)eObject;
            SchedulingParameterImpl cfr_ignored_0 = (SchedulingParameterImpl)eObject;
            if (sp.getKey() == null || sp.getValue() == null || sp.getValue().eClass() == null) {
                return;
            }
            Set<EClass> valueEClasses = AmOSSchedulingParameterValueTypeMatchesDefinedType.getAllUsedEClassesForParameterValue(sp.getValue());
            Set<EClass> allowedEClasses = AmOSSchedulingParameterValueTypeMatchesDefinedType.getAllowedEClassesForParameterDefinition(sp.getKey());
            if (!allowedEClasses.containsAll(valueEClasses)) {
                this.addIssue(results, (EObject)sp, (EStructuralFeature)ePackage.getSchedulingParameter_Value(), "The value of " + this.typeInfo((EObject)sp) + " \"" + sp.getKey().getName() + "\" does not conform to the defined type " + sp.getKey().getType());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Set<EClass> getAllUsedEClassesForParameterValue(Value value) {
        HashSet<EClass> ret = new HashSet<EClass>();
        if (value == null || value.eClass() == null) {
            return ret;
        }
        Value value2 = value;
        if (value2 instanceof ListObject) {
            void lo;
            ListObject listObject = (ListObject)value2;
            ListObject cfr_ignored_0 = (ListObject)value2;
            lo.getValues().forEach(v -> {
                boolean bl = ret.addAll(AmOSSchedulingParameterValueTypeMatchesDefinedType.getAllUsedEClassesForParameterValue(v));
            });
        } else {
            ret.add(value.eClass());
        }
        return ret;
    }

    private static Set<EClass> getAllowedEClassesForParameterDefinition(SchedulingParameterDefinition spd) {
        HashSet<EClass> ret = new HashSet<EClass>();
        if (spd.getType() == null) {
            return ret;
        }
        switch (spd.getType()) {
            case _UNDEFINED_: {
                ret.addAll(List.of(AmaltheaPackage.eINSTANCE.getBooleanObject(), AmaltheaPackage.eINSTANCE.getDoubleObject(), AmaltheaPackage.eINSTANCE.getFloatObject(), AmaltheaPackage.eINSTANCE.getBigIntegerObject(), AmaltheaPackage.eINSTANCE.getLongObject(), AmaltheaPackage.eINSTANCE.getIntegerObject(), AmaltheaPackage.eINSTANCE.getStringObject(), AmaltheaPackage.eINSTANCE.getTime()));
                break;
            }
            case BOOL: {
                ret.add(AmaltheaPackage.eINSTANCE.getBooleanObject());
                break;
            }
            case FLOAT: {
                ret.addAll(List.of(AmaltheaPackage.eINSTANCE.getDoubleObject(), AmaltheaPackage.eINSTANCE.getFloatObject()));
                break;
            }
            case INTEGER: {
                ret.addAll(List.of(AmaltheaPackage.eINSTANCE.getBigIntegerObject(), AmaltheaPackage.eINSTANCE.getLongObject(), AmaltheaPackage.eINSTANCE.getIntegerObject()));
                break;
            }
            case STRING: {
                ret.add(AmaltheaPackage.eINSTANCE.getStringObject());
                break;
            }
            case TIME: {
                ret.add(AmaltheaPackage.eINSTANCE.getTime());
            }
        }
        if (spd.isMany()) {
            ret.add(AmaltheaPackage.eINSTANCE.getListObject());
        }
        return ret;
    }
}

