/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.util.svg;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;

public class PlantUmlUtil {
    private PlantUmlUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void exportToFile(String source, String path) throws IOException {
        if (source == null || path == null || source.isEmpty() || path.isEmpty()) {
            return;
        }
        String extension = path.substring(path.lastIndexOf(46) + 1);
        FileFormat format = PlantUmlUtil.getFileformatFor(extension);
        ByteArrayOutputStream baos = PlantUmlUtil.renderToStream(source, format);
        if (baos == null) {
            return;
        }
        File file = new File(path);
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            baos.writeTo(fos);
            fos.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String renderToString(String source, FileFormat format) throws IOException {
        ByteArrayOutputStream baos = PlantUmlUtil.renderToStream(source, format);
        if (baos != null) {
            return baos.toString(StandardCharsets.UTF_8.name());
        }
        return null;
    }

    public static ByteArrayOutputStream renderToStream(String source, FileFormat format) throws IOException {
        if (source == null || source.isEmpty()) {
            return null;
        }
        if (format == null) {
            return null;
        }
        SourceStringReader reader = new SourceStringReader(source);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DiagramDescription desc = reader.outputImage((OutputStream)baos, new FileFormatOption(format));
        if (desc != null && !desc.getDescription().isEmpty()) {
            return baos;
        }
        return null;
    }

    private static FileFormat getFileformatFor(String extension) {
        if (extension == null || extension.isEmpty()) {
            return null;
        }
        FileFormat[] fileFormatArray = FileFormat.values();
        int n = fileFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileFormat format = fileFormatArray[n2];
            if (format.name().equalsIgnoreCase(extension)) {
                return format;
            }
            ++n2;
        }
        return null;
    }
}

