/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort;

import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;

public class AggrSortDefinition
implements ITargetSort {
    private DimLevel[] aggrLevels;
    private String aggrName;
    private DimLevel[] axisQualifierLevel;
    private Object[] axisQualifierValue;
    private DimLevel targetLevel;
    private int direction;
    private static Logger logger = Logger.getLogger(AggrSortDefinition.class.getName());

    public AggrSortDefinition(DimLevel[] aggrLevels, String aggrName, DimLevel[] axisQualifierLevel, Object[] axisQualifierValue, DimLevel targetLevel, int direction) throws DataException {
        Object[] params = new Object[]{aggrLevels, aggrName, axisQualifierLevel, axisQualifierValue, targetLevel, direction};
        logger.entering(AggrSortDefinition.class.getName(), "AggrSortDefinition", params);
        this.checkAxisAgrument(axisQualifierLevel, axisQualifierValue);
        this.aggrLevels = aggrLevels;
        this.aggrName = aggrName;
        this.axisQualifierLevel = axisQualifierLevel;
        this.axisQualifierValue = axisQualifierValue;
        this.targetLevel = targetLevel;
        this.direction = direction;
        logger.exiting(AggrSortDefinition.class.getName(), "AggrSortDefinition");
    }

    private void checkAxisAgrument(DimLevel[] axisLevels, Object[] axisValues) throws DataException {
        if (axisLevels != null && axisValues != null && axisLevels.length == axisValues.length) {
            int i = 0;
            while (i < axisLevels.length) {
                if (axisLevels[i] == null) {
                    throw new DataException("data.olap.axis.level.CantBeNull");
                }
                if (axisValues[i] == null) {
                    throw new DataException("data.olap.axis.value.CantBeNull", axisLevels[i].getLevelName());
                }
                ++i;
            }
        }
    }

    public DimLevel[] getAggrLevels() {
        return this.aggrLevels;
    }

    public String getAggrName() {
        return this.aggrName;
    }

    public DimLevel[] getAxisQualifierLevel() {
        return this.axisQualifierLevel;
    }

    public Object[] getAxisQualifierValue() {
        return this.axisQualifierValue;
    }

    @Override
    public DimLevel getTargetLevel() {
        return this.targetLevel;
    }

    @Override
    public int getSortDirection() {
        return this.direction;
    }
}

