/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.reportitem.ui.ChartFilterFactory;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;

public class ChartReportItemUIUtil {
    public static ChartFilterFactory createChartFilterFactory(Object item) throws ExtendedElementException {
        if (item instanceof ExtendedItemHandle) {
            return ChartReportItemUIUtil.getChartFilterFactory(((ExtendedItemHandle)item).getReportItem());
        }
        if (item instanceof IReportItem) {
            return ChartReportItemUIUtil.createChartFilterFactory(item);
        }
        return new ChartFilterFactory();
    }

    private static ChartFilterFactory getChartFilterFactory(IReportItem adaptableObj) {
        ChartFilterFactory factory = (ChartFilterFactory)ChartUtil.getAdapter((Object)adaptableObj, ChartFilterFactory.class);
        if (factory != null) {
            return factory;
        }
        return new ChartFilterFactory();
    }

    public static int getExpressionBuilderStyle(int builderCommand) {
        if (builderCommand == 1) {
            return 14;
        }
        if (builderCommand == 2) {
            return 1;
        }
        if (builderCommand == 4) {
            return 25;
        }
        if (builderCommand == 3) {
            return 24;
        }
        if (builderCommand == 5) {
            return 13;
        }
        if (builderCommand == 9) {
            return 9;
        }
        if (builderCommand == 6) {
            return 10;
        }
        if (builderCommand == 7) {
            return 15;
        }
        if (builderCommand == 10) {
            return 11;
        }
        if (builderCommand == 8) {
            return 58;
        }
        return 0;
    }

    public static String getBackgroundImage(DesignElementHandle handle) {
        return handle.getStringProperty("backgroundImage");
    }

    public static Object[] getBackgroundPosition(DesignElementHandle handle) {
        Object x = null;
        Object y = null;
        if (handle != null) {
            Object px = handle.getProperty("backgroundPositionX");
            Object py = handle.getProperty("backgroundPositionY");
            if (px instanceof String) {
                x = px;
            } else if (px instanceof DimensionValue) {
                x = "%".equals(((DimensionValue)px).getUnits()) ? px : Integer.valueOf((int)DEUtil.convertoToPixel((Object)px));
            }
            if (py instanceof String) {
                y = py;
            } else if (py instanceof DimensionValue) {
                y = "%".equals(((DimensionValue)py).getUnits()) ? py : Integer.valueOf((int)DEUtil.convertoToPixel((Object)py));
            }
        }
        return new Object[]{x, y};
    }

    public static int getBackgroundRepeat(DesignElementHandle handle) {
        return ChartReportItemUIUtil.getRepeat(handle.getStringProperty("backgroundRepeat"));
    }

    public static int getRepeat(String repeat) {
        if ("repeat-x".equals(repeat)) {
            return 1;
        }
        if ("repeat-y".equals(repeat)) {
            return 2;
        }
        if ("repeat".equals(repeat)) {
            return 3;
        }
        return 0;
    }

    public static List<ComputedColumn> generateComputedColumns(ReportItemHandle handle, DataSetHandle dataSetHandle) throws SemanticException {
        if (dataSetHandle != null) {
            List resultSetColumnList = DataUtil.getColumnList((DataSetHandle)dataSetHandle);
            ArrayList<ComputedColumn> columnList = new ArrayList<ComputedColumn>();
            for (ResultSetColumnHandle resultSetColumn : resultSetColumnList) {
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)handle, (String)resultSetColumn.getColumnName());
                column.setDataType(resultSetColumn.getDataType());
                ExpressionUtility.setBindingColumnExpression((Object)resultSetColumn, (ComputedColumn)column);
                column.setDisplayName(UIUtil.getColumnDisplayName((ResultSetColumnHandle)resultSetColumn));
                String displayKey = UIUtil.getColumnDisplayNameKey((ResultSetColumnHandle)resultSetColumn);
                if (displayKey != null) {
                    column.setDisplayNameID(displayKey);
                }
                columnList.add(column);
            }
            return columnList;
        }
        return Collections.emptyList();
    }

    public static void refreshBackground(ExtendedItemHandle handle, ReportElementFigure figure) {
        ChartReportItemUIUtil.refreshBackgroundColor(handle, (IFigure)figure);
        ChartReportItemUIUtil.refreshBackgroundImage(handle, figure);
    }

    public static void refreshBackgroundImage(ExtendedItemHandle handle, ReportElementFigure figure) {
        String backGroundImage = ChartReportItemUIUtil.getBackgroundImage((DesignElementHandle)handle);
        if (backGroundImage == null) {
            figure.setImage(null);
        } else {
            Image image = null;
            String imageSourceType = "embed";
            Object obj = handle.getProperty("backgroundImageType");
            if (obj instanceof String) {
                imageSourceType = obj.toString();
            }
            try {
                image = imageSourceType.equalsIgnoreCase("embed") ? ImageManager.getInstance().getEmbeddedImage(handle.getModuleHandle(), backGroundImage) : ImageManager.getInstance().getImage(handle.getModuleHandle(), backGroundImage);
            }
            catch (SWTException e) {
                image = null;
            }
            if (image == null) {
                figure.setImage(null);
                return;
            }
            figure.setImage(image);
            Object[] backGroundPosition = ChartReportItemUIUtil.getBackgroundPosition((DesignElementHandle)handle);
            int backGroundRepeat = ChartReportItemUIUtil.getBackgroundRepeat((DesignElementHandle)handle);
            figure.setRepeat(backGroundRepeat);
            Object xPosition = backGroundPosition[0];
            Object yPosition = backGroundPosition[1];
            Rectangle area = figure.getClientArea();
            org.eclipse.swt.graphics.Rectangle imageArea = image.getBounds();
            Point position = new Point(-1, -1);
            int alignment = 0;
            if (xPosition instanceof Integer) {
                position.x = (Integer)xPosition;
            } else if (xPosition instanceof DimensionValue) {
                int percentX = (int)((DimensionValue)xPosition).getMeasure();
                position.x = (area.width - imageArea.width) * percentX / 100;
            } else if (xPosition instanceof String) {
                alignment |= DesignElementHandleAdapter.getPosition((String)((String)xPosition));
            }
            if (yPosition instanceof Integer) {
                position.y = (Integer)yPosition;
            } else if (yPosition instanceof DimensionValue) {
                int percentY = (int)((DimensionValue)yPosition).getMeasure();
                position.y = (area.width - imageArea.width) * percentY / 100;
            } else if (yPosition instanceof String) {
                alignment |= DesignElementHandleAdapter.getPosition((String)((String)yPosition));
            }
            figure.setAlignment(alignment);
            figure.setPosition(position);
        }
    }

    public static void refreshBackgroundColor(ExtendedItemHandle handle, IFigure figure) {
        Object obj = handle.getProperty("backgroundColor");
        figure.setOpaque(false);
        if (obj != null) {
            int color = 0xFFFFFF;
            color = obj instanceof String ? ColorUtil.parseColor((String)((String)obj)) : (Integer)obj;
            figure.setBackgroundColor(ColorManager.getColor((int)color));
            figure.setOpaque(true);
        }
    }
}

