/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import com.ibm.icu.util.ULocale;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.FontUtil;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.svg.SVGDisplayServer;
import org.eclipse.birt.chart.device.svg.SVGGraphics2D;
import org.eclipse.birt.chart.device.svg.SVGImage;
import org.eclipse.birt.chart.device.svg.SVGInteractiveRenderer;
import org.eclipse.birt.chart.device.svg.SVGTextRenderer;
import org.eclipse.birt.chart.device.swing.SwingRendererImpl;
import org.eclipse.birt.chart.device.util.ITextLayoutFactory;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.ImageRenderEvent;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureChangeEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class SVGRendererImpl
extends SwingRendererImpl {
    protected List<String> scriptRefList = null;
    protected List<String> scriptCodeList = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.svg/trace");
    private IUpdateNotifier _iun = null;
    protected SVGInteractiveRenderer ivRenderer;
    private static final String SVG_VERSION = "-//W3C//DTD SVG 1.0//EN";
    private static final String SVG_DTD = "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd";
    private static final String XMLNS = "http://www.w3.org/2000/svg";
    private static final String XMLNSXINK = "http://www.w3.org/1999/xlink";
    protected Object oOutputIdentifier = null;
    protected Document dom;
    protected SVGGraphics2D svggc;
    protected boolean _resizeSVG = false;
    public boolean _enableScript = true;

    protected void init() {
        PluginSettings ps = PluginSettings.instance();
        try {
            SVGDisplayServer ids = (SVGDisplayServer)ps.getDisplayServer("ds.SVG");
            SVGTextRenderer tr = new SVGTextRenderer((IDisplayServer)ids);
            tr.setTextLayoutFactory((ITextLayoutFactory)ids);
            this._ids = ids;
            this._tr = tr;
            this.ivRenderer = new SVGInteractiveRenderer((IDeviceRenderer)this);
        }
        catch (ChartException pex) {
            logger.log((Exception)((Object)pex));
        }
    }

    public void setProperty(String sProperty, Object oValue) {
        super.setProperty(sProperty, oValue);
        if (sProperty.equals("device.component")) {
            this._iun = (IUpdateNotifier)oValue;
            this.ivRenderer.setIUpdateNotifier(this._iun);
        } else if (sProperty.equals("device.bounds")) {
            Bounds bo = (Bounds)oValue;
            try {
                this.dom = this.createSvgDocument(bo.getWidth(), bo.getHeight());
                this.svggc = new SVGGraphics2D(this.dom, this._enableScript);
                this.ivRenderer.setSVG2D(this.svggc);
                this.ivRenderer.createHotspotLayer(this.dom);
                super.setProperty("device.output.context", (Object)this.svggc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (sProperty.equals("device.file.identifier")) {
            this.oOutputIdentifier = oValue;
        } else if (sProperty.equals("javascript.code.list")) {
            this.scriptCodeList = (List)oValue;
        } else if (sProperty.equals("javascript.ref.list")) {
            this.scriptRefList = (List)oValue;
        } else if (sProperty.equals("resize.svg")) {
            this._resizeSVG = (Boolean)oValue;
        } else if (sProperty.equals("enable.scriptable")) {
            this._enableScript = (Boolean)oValue;
        }
    }

    protected void addScripts() {
        int x;
        if (this.scriptCodeList != null) {
            x = 0;
            while (x < this.scriptCodeList.size()) {
                String code = this.scriptCodeList.get(x);
                ((SVGGraphics2D)((Object)this._g2d)).addScript(code);
                ++x;
            }
        }
        if (this.scriptRefList != null) {
            x = 0;
            while (x < this.scriptRefList.size()) {
                String ref = this.scriptRefList.get(x);
                ((SVGGraphics2D)((Object)this._g2d)).addScriptRef(ref);
                ++x;
            }
        }
    }

    public void after() throws ChartException {
        super.after();
        this.ivRenderer.addInteractivity();
        this.addScripts();
        ((SVGGraphics2D)((Object)this._g2d)).flush();
        this.dom.getDocumentElement().appendChild(this.ivRenderer.getHotspotLayer());
        if (this.oOutputIdentifier instanceof OutputStream) {
            try {
                this.writeDocumentToOutputStream(this.dom, (OutputStream)this.oOutputIdentifier);
            }
            catch (Exception ex) {
                throw new ChartException("org.eclipse.birt.chart.device.svg", 11, (Throwable)ex);
            }
        } else if (this.oOutputIdentifier instanceof String) {
            FileOutputStream fos = null;
            try {
                fos = SecurityUtil.newFileOutputStream((String)((String)this.oOutputIdentifier));
                this.writeDocumentToOutputStream(this.dom, fos);
                fos.close();
            }
            catch (Exception ex) {
                throw new ChartException("org.eclipse.birt.chart.device.svg", 11, (Throwable)ex);
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.device.svg", 11, "SVGRendererImpl.exception.UnableToWriteChartImage", new Object[]{this.oOutputIdentifier}, null);
        }
        this.ivRenderer.clear();
    }

    private void writeDocumentToOutputStream(Document svgDocument, OutputStream outputStream) throws Exception {
        if (svgDocument != null && outputStream != null) {
            OutputStreamWriter writer = SecurityUtil.newOutputStreamWriter((OutputStream)outputStream, (String)"UTF-8");
            DOMSource source = new DOMSource(svgDocument);
            StreamResult result = new StreamResult(writer);
            this.checkForTransformFactoryImpl();
            TransformerFactory transFactory = SecurityUtil.newTransformerFactory();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
    }

    private void checkForTransformFactoryImpl() {
        try {
            Class.forName("org.apache.xalan.processor.TransformerFactoryImpl");
        }
        catch (ClassNotFoundException e) {
            SecurityUtil.setSysProp((String)"javax.xml.transform.TransformerFactory", (String)"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        }
    }

    protected Document createSvgDocument() throws Exception {
        DocumentBuilderFactory factory = SecurityUtil.newDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        DocumentType dType = domImpl.createDocumentType("svg", SVG_VERSION, SVG_DTD);
        Document svgDocument = domImpl.createDocument(XMLNS, "svg", dType);
        svgDocument.getDocumentElement().setAttribute("xmlns", XMLNS);
        svgDocument.getDocumentElement().setAttribute("xmlns:xlink", XMLNSXINK);
        if (this._resizeSVG) {
            svgDocument.getDocumentElement().setAttribute("onload", "resizeSVG(evt)");
            svgDocument.getDocumentElement().setAttribute("onresize", "resizeSVG(evt)");
        }
        return svgDocument;
    }

    protected Document createSvgDocument(double width, double height) throws Exception {
        Document svgDocument = this.createSvgDocument();
        svgDocument.getDocumentElement().setAttribute("width", SVGGraphics2D.toString(width));
        svgDocument.getDocumentElement().setAttribute("height", SVGGraphics2D.toString(height));
        svgDocument.getDocumentElement().setAttribute("initialWidth", SVGGraphics2D.toString(width));
        svgDocument.getDocumentElement().setAttribute("initialHeight", SVGGraphics2D.toString(height));
        return svgDocument;
    }

    public void changeStructure(StructureChangeEvent scev) {
    }

    protected void removeGroupStructure(Object block) {
        if (block instanceof TitleBlock || block instanceof Legend || block instanceof Plot || block instanceof LabelBlock || block instanceof Series || block instanceof DataPointHints) {
            this.svggc.popParent();
        }
    }

    protected void addGroupStructure(Object block) {
        if (block instanceof TitleBlock) {
            Element group = this.svggc.dom.createElement("g");
            group.setAttribute("id", "title");
            this.svggc.pushParent(group);
        } else if (block instanceof Legend) {
            Element group = this.svggc.dom.createElement("g");
            group.setAttribute("id", "legend");
            this.svggc.pushParent(group);
        } else if (block instanceof Plot) {
            Element group = this.svggc.dom.createElement("g");
            group.setAttribute("id", "plot");
            this.svggc.pushParent(group);
        } else if (block instanceof LabelBlock) {
            Element group = this.svggc.dom.createElement("g");
            group.setAttribute("id", "label");
            this.svggc.pushParent(group);
        } else if (block instanceof Series) {
            Element group = this.svggc.dom.createElement("g");
            group.setAttribute("id", "series");
            this.svggc.pushParent(group);
        } else if (block instanceof DataPointHints) {
            Element group = this.svggc.dom.createElement("g");
            group.setAttribute("id", "dp" + block.hashCode());
            this.svggc.pushParent(group);
        }
    }

    public void enableInteraction(InteractionEvent ie) throws ChartException {
        if (this._iun == null) {
            logger.log(2, Messages.getString((String)"exception.missing.component.interaction", (ULocale)this.getULocale()));
            return;
        }
        Trigger[] triggers = ie.getTriggers();
        if (triggers == null) {
            return;
        }
        PrimitiveRenderEvent pre = ie.getHotSpot();
        Element elm = null;
        if (pre instanceof PolygonRenderEvent) {
            Location[] loa = ((PolygonRenderEvent)pre).getPoints();
            double[][] pa = SVGRendererImpl.getCoordinates((Location[])loa);
            elm = this.svggc.createPolygon(pa[0], pa[1], pa[0].length);
        } else if (pre instanceof OvalRenderEvent) {
            Bounds boEllipse = ((OvalRenderEvent)pre).getBounds();
            elm = this.svggc.createOval(boEllipse.getLeft() + boEllipse.getWidth() / 2.0, boEllipse.getTop() + boEllipse.getHeight() / 2.0, boEllipse.getWidth() / 2.0, boEllipse.getHeight() / 2.0);
        } else if (pre instanceof RectangleRenderEvent) {
            Bounds boRect = ((RectangleRenderEvent)pre).getBounds();
            elm = this.svggc.createRect(boRect.getLeft(), boRect.getTop(), boRect.getWidth(), boRect.getHeight());
        } else if (pre instanceof AreaRenderEvent) {
            AreaRenderEvent are = (AreaRenderEvent)pre;
            GeneralPath gp = new GeneralPath();
            int i = 0;
            while (i < are.getElementCount()) {
                PrimitiveRenderEvent subPre = are.getElement(i);
                if (subPre instanceof ArcRenderEvent) {
                    ArcRenderEvent acre = (ArcRenderEvent)subPre;
                    Arc2D.Double a2d = new Arc2D.Double(acre.getTopLeft().getX(), acre.getTopLeft().getY(), acre.getWidth(), acre.getHeight(), acre.getStartAngle(), acre.getAngleExtent(), SVGRendererImpl.toG2dArcType((int)acre.getStyle()));
                    gp.append(a2d, true);
                } else if (subPre instanceof LineRenderEvent) {
                    LineRenderEvent lre = (LineRenderEvent)subPre;
                    Line2D.Double l2d = new Line2D.Double(lre.getStart().getX(), lre.getStart().getY(), lre.getEnd().getX(), lre.getEnd().getY());
                    gp.append(l2d, true);
                }
                ++i;
            }
            elm = this.svggc.createGeneralPath(gp);
        } else if (pre instanceof LineRenderEvent) {
            GeneralPath gp = new GeneralPath();
            LineRenderEvent lre = (LineRenderEvent)pre;
            Line2D.Double l2d = new Line2D.Double(lre.getStart().getX(), lre.getStart().getY(), lre.getEnd().getX(), lre.getEnd().getY());
            gp.append(l2d, true);
            elm = this.svggc.createGeneralPath(gp);
        } else if (pre instanceof ArcRenderEvent) {
            ArcRenderEvent are = (ArcRenderEvent)pre;
            if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius()) {
                Arc2D.Double outerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getOuterRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getOuterRadius()) / 2.0, 2.0 * are.getOuterRadius(), 2.0 * are.getOuterRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
                Arc2D.Double innerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getInnerRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getInnerRadius()) / 2.0, 2.0 * are.getInnerRadius(), 2.0 * are.getInnerRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
                Area fArea = new Area(outerArc);
                fArea.exclusiveOr(new Area(innerArc));
                elm = this.svggc.createGeneralPath(fArea);
            } else {
                elm = this.svggc.createGeneralPath(new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), SVGRendererImpl.toG2dArcType((int)are.getStyle())));
            }
        }
        this.ivRenderer.prepareInteractiveEvent(elm, ie, triggers);
    }

    public void drawArc(ArcRenderEvent are) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)are, false);
        super.drawArc(are);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)are, false);
    }

    public void drawArea(AreaRenderEvent are) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)are, false);
        super.drawArea(are);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)are, false);
    }

    public void drawImage(ImageRenderEvent pre) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)pre, false);
        super.drawImage(pre);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)pre, false);
    }

    protected Image createImage(byte[] data) {
        return new SVGImage(super.createImage(data), null, data);
    }

    public void drawLine(LineRenderEvent lre) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)lre, false);
        super.drawLine(lre);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)lre, false);
    }

    public void drawOval(OvalRenderEvent ore) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)ore, false);
        super.drawOval(ore);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)ore, false);
    }

    public void drawPolygon(PolygonRenderEvent pre) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)pre, false);
        super.drawPolygon(pre);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)pre, false);
    }

    public void drawRectangle(RectangleRenderEvent rre) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)rre, false);
        super.drawRectangle(rre);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)rre, false);
    }

    public void fillArc(ArcRenderEvent are) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)are, false);
        super.fillArc(are);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)are, false);
    }

    public void fillArea(AreaRenderEvent are) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)are, false);
        super.fillArea(are);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)are, false);
    }

    public void fillOval(OvalRenderEvent ore) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)ore, false);
        super.fillOval(ore);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)ore, false);
    }

    public void fillPolygon(PolygonRenderEvent pre) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)pre, false);
        super.fillPolygon(pre);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)pre, false);
    }

    public void fillRectangle(RectangleRenderEvent rre) throws ChartException {
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)rre, false);
        super.fillRectangle(rre);
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)rre, false);
    }

    public void drawText(TextRenderEvent tre) throws ChartException {
        String fontName = this.convertFont(tre.getLabel().getCaption().getFont().getName());
        if (fontName != null) {
            tre.getLabel().getCaption().getFont().setName(fontName);
        }
        this.ivRenderer.groupPrimitive((PrimitiveRenderEvent)tre, true);
        switch (tre.getAction()) {
            case 0: {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "exception.missing.text.render.action", Messages.getResourceBundle((ULocale)this.getULocale()));
            }
            case 1: {
                this._tr.renderShadowAtLocation((IPrimitiveRenderer)this, tre.getTextPosition(), tre.getLocation(), tre.getLabel());
                break;
            }
            case 2: {
                this._tr.renderTextAtLocation((IPrimitiveRenderer)this, tre.getTextPosition(), tre.getLocation(), tre.getLabel());
                break;
            }
            case 3: {
                this._tr.renderTextInBlock((IDeviceRenderer)this, tre.getBlockBounds(), tre.getBlockAlignment(), tre.getLabel());
            }
        }
        this.ivRenderer.ungroupPrimitive((PrimitiveRenderEvent)tre, true);
    }

    public String getMimeType() {
        return "image/svg+xml";
    }

    protected String convertFont(String fontFamily) {
        return FontUtil.getFontFamily((String)fontFamily);
    }

    protected Image createImageFromModel(Fill imageModel) throws ChartException {
        Image img = super.createImageFromModel(imageModel);
        if (img != null && !(img instanceof SVGImage)) {
            img = new SVGImage(img, null);
        }
        return img;
    }

    protected BufferedImage convertPatternImage(Image img) {
        if (img instanceof SVGImage) {
            img = ((SVGImage)img).image;
        }
        return super.convertPatternImage(img);
    }

    protected Shape getPolygon(Location[] loa) {
        return SVGRendererImpl.getPolygon2D((Location[])loa);
    }
}

