/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.versioning;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.BiMap;
import org.gradle.internal.impldep.com.google.common.collect.HashBiMap;
import org.gradle.tooling.internal.protocol.InternalBasicIdeaProject;
import org.gradle.tooling.internal.protocol.InternalBuildEnvironment;
import org.gradle.tooling.internal.protocol.InternalGradleProject;
import org.gradle.tooling.internal.protocol.InternalIdeaProject;
import org.gradle.tooling.internal.protocol.InternalProjectOutcomes;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.protocol.eclipse.EclipseProjectVersion3;
import org.gradle.tooling.internal.protocol.eclipse.HierarchicalEclipseProjectVersion1;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.gradle.ProjectPublications;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMapping {
    private static final BiMap<Class<?>, Class<?>> MODEL_TO_PROTOCOL_MAP = HashBiMap.create();
    private static final BiMap<Class<?>, String> MODEL_NAME_MAP = HashBiMap.create();
    private static final Map<Class<?>, String> MODEL_VERSIONS = new HashMap();

    private static void addModelVersions(Map<Class<?>, String> map) {
        map.put(HierarchicalEclipseProject.class, "1.0-milestone-3");
        map.put(EclipseProject.class, "1.0-milestone-3");
        map.put(IdeaProject.class, "1.0-milestone-5");
        map.put(GradleProject.class, "1.0-milestone-5");
        map.put(BasicIdeaProject.class, "1.0-milestone-5");
        map.put(BuildEnvironment.class, "1.0-milestone-8");
        map.put(ProjectOutcomes.class, "1.2");
        map.put(Void.class, "1.0-milestone-3");
        map.put(GradleBuild.class, "1.8");
        map.put(ProjectPublications.class, "1.12");
    }

    static void addModelToProtocolMappings(Map<Class<?>, Class<?>> map) {
        map.put(HierarchicalEclipseProject.class, HierarchicalEclipseProjectVersion1.class);
        map.put(EclipseProject.class, EclipseProjectVersion3.class);
        map.put(IdeaProject.class, InternalIdeaProject.class);
        map.put(GradleProject.class, InternalGradleProject.class);
        map.put(BasicIdeaProject.class, InternalBasicIdeaProject.class);
        map.put(BuildEnvironment.class, InternalBuildEnvironment.class);
        map.put(ProjectOutcomes.class, InternalProjectOutcomes.class);
        map.put(Void.class, Void.class);
    }

    static void addModelNameMappings(Map<Class<?>, String> map) {
        map.put(HierarchicalEclipseProject.class, "org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
        map.put(EclipseProject.class, "org.gradle.tooling.model.eclipse.EclipseProject");
        map.put(IdeaProject.class, "org.gradle.tooling.model.idea.IdeaProject");
        map.put(GradleProject.class, "org.gradle.tooling.model.GradleProject");
        map.put(BasicIdeaProject.class, "org.gradle.tooling.model.idea.BasicIdeaProject");
        map.put(BuildEnvironment.class, "org.gradle.tooling.model.build.BuildEnvironment");
        map.put(ProjectOutcomes.class, "org.gradle.tooling.model.outcomes.ProjectOutcomes");
        map.put(Void.class, Void.class.getName());
    }

    public ModelIdentifier getModelIdentifierFromModelType(Class<?> modelType) {
        if (modelType.equals(Void.class)) {
            return new DefaultModelIdentifier(ModelIdentifier.NULL_MODEL);
        }
        String modelName = this.getModelName(modelType);
        if (modelName != null) {
            return new DefaultModelIdentifier(modelName);
        }
        return new DefaultModelIdentifier(modelType.getName());
    }

    @Nullable
    public Class<?> getProtocolType(Class<?> modelType) {
        if (MODEL_TO_PROTOCOL_MAP.containsValue(modelType)) {
            return modelType;
        }
        return (Class)MODEL_TO_PROTOCOL_MAP.get(modelType);
    }

    @Nullable
    public String getModelName(Class<?> modelType) {
        return (String)MODEL_NAME_MAP.get(modelType);
    }

    @Nullable
    public String getModelNameFromProtocolType(Class<?> protocolType) {
        Class modelType = (Class)MODEL_TO_PROTOCOL_MAP.inverse().get(protocolType);
        if (modelType == null) {
            return null;
        }
        return (String)MODEL_NAME_MAP.get(modelType);
    }

    @Nullable
    public Class<?> getProtocolTypeFromModelName(String name) {
        Class modelType = (Class)MODEL_NAME_MAP.inverse().get(name);
        if (modelType == null) {
            return null;
        }
        return this.getProtocolType(modelType);
    }

    @Nullable
    public String getVersionAdded(Class<?> modelType) {
        return MODEL_VERSIONS.get(modelType);
    }

    static {
        ModelMapping.addModelToProtocolMappings(MODEL_TO_PROTOCOL_MAP);
        ModelMapping.addModelNameMappings(MODEL_NAME_MAP);
        ModelMapping.addModelVersions(MODEL_VERSIONS);
    }

    private static class DefaultModelIdentifier
    implements ModelIdentifier {
        private final String model;

        public DefaultModelIdentifier(String model) {
            this.model = model;
        }

        public String toString() {
            return "tooling model " + this.model;
        }

        public String getName() {
            return this.model;
        }
    }
}

