/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transformers {
    public static <O, I> Transformer<O, I> cast(Class<O> outputType) {
        return new CastingTransformer(outputType);
    }

    public static <T> Transformer<T, T> noOpTransformer() {
        return new Transformer<T, T>(){

            @Override
            public T transform(T original) {
                return original;
            }
        };
    }

    public static <T> Transformer<String, T> asString() {
        return new ToStringTransformer();
    }

    public static Transformer<String, String> asSafeCommandLineArgument() {
        return new CommandLineArgumentTransformer();
    }

    public static <T> Transformer<Class<T>, T> type() {
        return new Transformer<Class<T>, T>(){

            @Override
            public Class<T> transform(T original) {
                Class<?> aClass = original.getClass();
                return aClass;
            }
        };
    }

    public static <R> Transformer<R, Object> toTransformer(final Factory<R> factory) {
        return new Transformer<R, Object>(){

            @Override
            public R transform(Object original) {
                return factory.create();
            }
        };
    }

    public static <R, I> Transformer<R, I> toTransformer(final Action<? super I> action) {
        return new Transformer<R, I>(){

            @Override
            public R transform(I original) {
                action.execute(original);
                return null;
            }
        };
    }

    public static Transformer<URL, URI> toURL() {
        return new Transformer<URL, URI>(){

            @Override
            public URL transform(URI original) {
                try {
                    return original.toURL();
                }
                catch (MalformedURLException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        };
    }

    public static <T, I> Transformer<T, I> constant(final T t) {
        return new Transformer<T, I>(){

            @Override
            public T transform(I original) {
                return t;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastingTransformer<O, I>
    implements Transformer<O, I> {
        final Class<O> outputType;

        public CastingTransformer(Class<O> outputType) {
            this.outputType = outputType;
        }

        @Override
        public O transform(I input) {
            return Cast.cast(this.outputType, input);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandLineArgumentTransformer
    implements Transformer<String, String> {
        private static final Pattern SINGLE_QUOTED = Pattern.compile("^'.*'$");
        private static final Pattern DOUBLE_QUOTED = Pattern.compile("^\".*\"$");
        private static final Pattern A_SINGLE_QUOTE = Pattern.compile("'");

        private CommandLineArgumentTransformer() {
        }

        @Override
        public String transform(String input) {
            if (SINGLE_QUOTED.matcher(input).matches() || DOUBLE_QUOTED.matcher(input).matches() || !input.contains(" ")) {
                return input;
            }
            return this.wrapWithSingleQuotes(input);
        }

        private String wrapWithSingleQuotes(String input) {
            return String.format("'%1$s'", this.escapeSingleQuotes(input));
        }

        private String escapeSingleQuotes(String input) {
            return A_SINGLE_QUOTE.matcher(input).replaceAll("\\\\'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToStringTransformer<T>
    implements Transformer<String, T> {
        private ToStringTransformer() {
        }

        @Override
        public String transform(T original) {
            return original == null ? null : original.toString();
        }
    }
}

