/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.view.execution.ExecutionPage;
import org.eclipse.buildship.ui.view.execution.ExecutionViewMessages;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;

public final class RerunBuildExecutionAction
extends Action {
    private final ExecutionPage page;

    public RerunBuildExecutionAction(ExecutionPage executionPage) {
        this.page = (ExecutionPage)Preconditions.checkNotNull((Object)executionPage);
        this.setToolTipText(ExecutionViewMessages.Action_RerunBuild_Tooltip);
        this.setImageDescriptor(PluginImages.RERUN_BUILD.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.RERUN_BUILD.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Job job = this.page.getBuildJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                RerunBuildExecutionAction.this.setEnabled(event.getJob().getState() == 0);
            }
        });
        this.setEnabled(job.getState() == 0);
    }

    public void run() {
        ILaunchConfiguration launchConfiguration = CorePlugin.gradleLaunchConfigurationManager().getOrCreateRunConfiguration(this.page.getConfigurationAttributes());
        DebugUITools.launch((ILaunchConfiguration)launchConfiguration, (String)"run");
    }
}

