/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.consumer.converters.EclipseProjectDependencyTargetMixin;
import org.gradle.tooling.internal.consumer.converters.EclipseProjectIdentifierMixin;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.eclipse.EclipseProjectDependency;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseModelCompatibilityMapping
implements Action<SourceObjectMapping>,
Serializable {
    private final boolean versionSupportsEclipseProjectIdentifier;

    public EclipseModelCompatibilityMapping(VersionDetails versionDetails) {
        GradleVersion targetGradleVersion = GradleVersion.version(versionDetails.getVersion());
        this.versionSupportsEclipseProjectIdentifier = this.supportsEclipseProjectIdentifier(targetGradleVersion);
    }

    @Override
    public void execute(SourceObjectMapping mapping) {
        Class<?> targetType = mapping.getTargetType();
        if (!this.versionSupportsEclipseProjectIdentifier) {
            if (EclipseProjectDependency.class.isAssignableFrom(targetType)) {
                mapping.mixIn(EclipseProjectDependencyTargetMixin.class);
            } else if (HierarchicalEclipseProject.class.isAssignableFrom(targetType)) {
                mapping.mixIn(EclipseProjectIdentifierMixin.class);
            }
        }
    }

    private boolean supportsEclipseProjectIdentifier(GradleVersion targetGradleVersion) {
        return targetGradleVersion.getBaseVersion().compareTo(GradleVersion.version("2.14")) >= 0;
    }
}

