/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;

public final class TaskViewActionStateRules {
    private TaskViewActionStateRules() {
    }

    public static boolean taskScopedTaskExecutionActionsVisibleFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(TaskNode.class);
    }

    public static boolean taskScopedTaskExecutionActionsEnabledFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return (nodeSelection.hasAllNodesOfType(ProjectTaskNode.class) || nodeSelection.hasAllNodesOfType(TaskSelectorNode.class)) && TaskViewActionStateRules.taskNodesBelongToSameParentProjectNode(nodeSelection);
    }

    private static boolean taskNodesBelongToSameParentProjectNode(NodeSelection nodeSelection) {
        Preconditions.checkArgument((!nodeSelection.isEmpty() ? 1 : 0) != 0);
        final TaskNode firstNode = (TaskNode)nodeSelection.getFirstNode();
        return nodeSelection.allMatch(new Predicate<Object>(){

            public boolean apply(Object input) {
                return ((TaskNode)input).getParentProjectNode() == firstNode.getParentProjectNode();
            }
        });
    }

    public static boolean projectScopedTaskExecutionActionsVisibleFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(ProjectNode.class);
    }

    public static boolean projectScopedTaskExecutionActionsEnabledFor(NodeSelection nodeSelection) {
        if (nodeSelection.isEmpty()) {
            return false;
        }
        return nodeSelection.hasAllNodesOfType(ProjectNode.class) && nodeSelection.isSingleSelection();
    }
}

