/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleProjectStructure;
import com.gradleware.tooling.toolingmodel.util.Pair;
import com.gradleware.tooling.toolingutils.binding.Property;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.gradle.MissingFeatures;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.gradle.GradleDistributionFormatter;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.util.font.FontUtils;
import org.eclipse.buildship.ui.util.layout.LayoutUtils;
import org.eclipse.buildship.ui.util.widget.UiBuilder;
import org.eclipse.buildship.ui.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.ProgressListener;
import org.gradle.util.GradleVersion;

public final class ProjectPreviewWizardPage
extends AbstractWizardPage {
    private final ProjectPreviewLoader projectPreviewLoader;
    private final Font keyFont;
    private final Font valueFont;
    private final String pageContextInformation;
    private Label projectDirLabel;
    private Label gradleUserHomeLabel;
    private Label gradleDistributionLabel;
    private Label gradleVersionLabel;
    private Label gradleVersionWarningLabel;
    private Label javaHomeLabel;
    private Tree projectPreviewTree;

    public ProjectPreviewWizardPage(ProjectImportConfiguration configuration, ProjectPreviewLoader previewLoader) {
        this(configuration, previewLoader, ProjectWizardMessages.Title_PreviewImportWizardPage, ProjectWizardMessages.InfoMessage_GradlePreviewWizardPageDefault, ProjectWizardMessages.InfoMessage_GradlePreviewWizardPageContext);
    }

    public ProjectPreviewWizardPage(ProjectImportConfiguration configuration, ProjectPreviewLoader previewLoader, String title, String defaultMessage, String pageContextInformation) {
        super("ProjectPreview", title, defaultMessage, configuration, (List<Property<?>>)ImmutableList.of());
        this.projectPreviewLoader = (ProjectPreviewLoader)Preconditions.checkNotNull((Object)previewLoader);
        this.keyFont = FontUtils.getCustomDialogFont(1);
        this.valueFont = FontUtils.getCustomDialogFont(0);
        this.pageContextInformation = pageContextInformation;
    }

    @Override
    protected void createWidgets(Composite root) {
        root.setLayout(this.createLayout());
        this.createContent(root);
    }

    private Layout createLayout() {
        GridLayout layout = LayoutUtils.newGridLayout(2);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        return layout;
    }

    private void createContent(Composite root) {
        this.createSummaryLabels(root);
        this.createPreviewGroup(root);
        this.updatePreviewLabels(this.getConfiguration());
    }

    private void createSummaryLabels(Composite container) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_ProjectRootDirectory + ":").font(this.keyFont).alignLeft();
        this.projectDirLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleUserHome + ":").font(this.keyFont).alignLeft();
        this.gradleUserHomeLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleDistribution + ":").font(this.keyFont).alignLeft();
        this.gradleDistributionLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleVersion + ":").font(this.keyFont).alignLeft();
        Composite gradleVersionContainer = new Composite(container, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)gradleVersionContainer);
        GridLayoutFactory.swtDefaults().margins(0, 0).extendedMargins(0, 0, 0, 0).spacing(0, 0).numColumns(2).applyTo(gradleVersionContainer);
        this.gradleVersionLabel = uiBuilderFactory.newLabel(gradleVersionContainer).alignLeft().disabled().font(this.valueFont).control();
        this.gradleVersionWarningLabel = uiBuilderFactory.newLabel(gradleVersionContainer).alignLeft().control();
        this.gradleVersionWarningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.gradleVersionWarningLabel.setCursor(gradleVersionContainer.getDisplay().getSystemCursor(21));
        this.gradleVersionWarningLabel.setToolTipText(ProjectWizardMessages.Missing_Features_Tooltip);
        this.gradleVersionWarningLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                String version = ProjectPreviewWizardPage.this.gradleVersionLabel.getText();
                MissingFeatures limitations = new MissingFeatures(GradleVersion.version((String)version));
                FluentIterable limitationMessages = FluentIterable.from((Iterable)limitations.getMissingFeatures()).transform((Function)new Function<Pair<GradleVersion, String>, String>(){

                    public String apply(Pair<GradleVersion, String> limitation) {
                        return (String)limitation.getSecond();
                    }
                });
                String message = NLS.bind((String)ProjectWizardMessages.Missing_Features_Details_0_1, (Object)version, (Object)Joiner.on((char)'\n').join((Iterable)limitationMessages));
                MessageDialog.openInformation((Shell)ProjectPreviewWizardPage.this.getShell(), (String)ProjectWizardMessages.Title_Dialog_Missing_Features, (String)message);
            }
        });
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_JavaHome + ":").font(this.keyFont).alignLeft();
        this.javaHomeLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
    }

    private void createPreviewGroup(Composite container) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_ProjectStructure + ":").font(this.keyFont).alignLeft();
        Label previewStructureInfoLabel = uiBuilderFactory.newLabel(container).alignLeft().control();
        previewStructureInfoLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        previewStructureInfoLabel.setCursor(container.getDisplay().getSystemCursor(21));
        previewStructureInfoLabel.setToolTipText(ProjectWizardMessages.PreviewStructureInfo_Tooltip);
        previewStructureInfoLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MessageDialog.openInformation((Shell)ProjectPreviewWizardPage.this.getShell(), (String)ProjectWizardMessages.Title_Dialog_PreviewStructureInfo, (String)ProjectWizardMessages.PreviewStructureInfo_Details);
            }
        });
        this.projectPreviewTree = uiBuilderFactory.newTree(container).alignFillBoth(2).control();
    }

    private void createSpacingRow(Composite container, int horizontalSpan) {
        GridData data = new GridData(16384, 0x1000000, false, false, horizontalSpan, 1);
        data.heightHint = 8;
        new Label(container, 0).setLayoutData((Object)data);
    }

    private void updatePreviewLabels(ProjectImportConfiguration configuration) {
        this.updateFileLabel(this.projectDirLabel, (Property<File>)configuration.getProjectDir(), CoreMessages.Value_UseGradleDefault);
        this.updateGradleDistributionLabel(this.gradleDistributionLabel, (Property<GradleDistributionWrapper>)configuration.getGradleDistribution(), CoreMessages.Value_UseGradleDefault);
        this.updateGradleVersionLabel(this.gradleVersionLabel, (Property<GradleDistributionWrapper>)configuration.getGradleDistribution(), CoreMessages.Value_Unknown);
        this.gradleUserHomeLabel.setText(CoreMessages.Value_Unknown);
        this.javaHomeLabel.setText(CoreMessages.Value_Unknown);
        this.updateGradleVersionWarningLabel();
    }

    private void updateFileLabel(Label target, Property<File> source, String defaultMessage) {
        File file = (File)source.getValue();
        target.setText(file != null ? file.getAbsolutePath() : defaultMessage);
    }

    private void updateGradleDistributionLabel(Label target, Property<GradleDistributionWrapper> gradleDistribution, String defaultMessage) {
        GradleDistributionWrapper gradleDistributionWrapper = (GradleDistributionWrapper)gradleDistribution.getValue();
        target.setText(gradleDistributionWrapper != null ? GradleDistributionFormatter.toString((GradleDistributionWrapper)gradleDistributionWrapper) : defaultMessage);
    }

    private void updateGradleVersionLabel(Label target, Property<GradleDistributionWrapper> gradleDistribution, String defaultMessage) {
        GradleDistributionWrapper gradleDistributionWrapper = (GradleDistributionWrapper)gradleDistribution.getValue();
        if (gradleDistributionWrapper == null) {
            target.setText(defaultMessage);
            return;
        }
        switch (gradleDistributionWrapper.getType()) {
            case WRAPPER: 
            case LOCAL_INSTALLATION: 
            case REMOTE_DISTRIBUTION: {
                target.setText(defaultMessage);
                break;
            }
            case VERSION: {
                target.setText(gradleDistributionWrapper.getConfiguration());
                break;
            }
            default: {
                throw new GradlePluginsRuntimeException("Unrecognized Gradle distribution type: " + gradleDistributionWrapper.getType());
            }
        }
        target.getParent().layout();
    }

    private void updateGradleVersionWarningLabel() {
        try {
            GradleVersion version = GradleVersion.version((String)this.gradleVersionLabel.getText());
            MissingFeatures missingFeatures = new MissingFeatures(version);
            this.gradleVersionWarningLabel.setVisible(!missingFeatures.getMissingFeatures().isEmpty());
        }
        catch (IllegalArgumentException e) {
            this.gradleVersionWarningLabel.setVisible(false);
        }
        this.gradleVersionLabel.getParent().layout();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updatePreviewLabels(this.getConfiguration());
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectPreviewWizardPage.this.scheduleProjectPreviewJob();
                }
            });
        }
    }

    private void scheduleProjectPreviewJob() {
        IWizardContainer container = this.getContainer();
        if (container == null) {
            return;
        }
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    monitor.beginTask("Loading project preview", -1);
                    CountDownLatch latch = new CountDownLatch(1);
                    ProgressListener listener = DelegatingProgressListener.withFullOutput((IProgressMonitor)monitor);
                    Job job = ProjectPreviewWizardPage.this.projectPreviewLoader.loadPreview(new ProjectPreviewJobResultHandler(latch), (List<ProgressListener>)ImmutableList.of((Object)listener));
                    while (!latch.await(500L, TimeUnit.MILLISECONDS)) {
                        if (!monitor.isCanceled()) continue;
                        job.cancel();
                        throw new InterruptedException();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UiPlugin.logger().error("Failed to load preview.", e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected String getPageContextInformation() {
        return this.pageContextInformation;
    }

    @Override
    public void dispose() {
        this.keyFont.dispose();
        this.valueFont.dispose();
        super.dispose();
    }

    private final class ProjectPreviewJobResultHandler
    implements FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuild>> {
        private final CountDownLatch latch;

        private ProjectPreviewJobResultHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onSuccess(Pair<OmniBuildEnvironment, OmniGradleBuild> result) {
            this.latch.countDown();
            this.updateSummary((OmniBuildEnvironment)result.getFirst());
            this.populateTree((OmniGradleBuild)result.getSecond());
        }

        public void onFailure(Throwable t) {
            this.latch.countDown();
            this.clearTree();
        }

        private void updateSummary(final OmniBuildEnvironment buildEnvironment) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ProjectPreviewWizardPage.this.getControl().isDisposed()) {
                        if (buildEnvironment.getGradle().getGradleUserHome().isPresent()) {
                            String gradleUserHome = ((File)buildEnvironment.getGradle().getGradleUserHome().get()).getAbsolutePath();
                            ProjectPreviewWizardPage.this.gradleUserHomeLabel.setText(gradleUserHome);
                        }
                        String gradleVersion = buildEnvironment.getGradle().getGradleVersion();
                        ProjectPreviewWizardPage.this.gradleVersionLabel.setText(gradleVersion);
                        ProjectPreviewWizardPage.this.updateGradleVersionWarningLabel();
                        String javaHome = buildEnvironment.getJava().getJavaHome().getAbsolutePath();
                        ProjectPreviewWizardPage.this.javaHomeLabel.setText(javaHome);
                    }
                }
            });
        }

        private void populateTree(final OmniGradleBuild buildStructure) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ProjectPreviewWizardPage.this.getControl().isDisposed()) {
                        ProjectPreviewWizardPage.this.projectPreviewTree.removeAll();
                        ProjectPreviewJobResultHandler.this.populateRecursively(buildStructure, ProjectPreviewWizardPage.this.projectPreviewTree);
                    }
                }
            });
        }

        private void clearTree() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ProjectPreviewWizardPage.this.getControl().isDisposed()) {
                        ProjectPreviewWizardPage.this.projectPreviewTree.removeAll();
                    }
                }
            });
        }

        private void populateRecursively(OmniGradleBuild gradleBuild, Tree parent) {
            OmniGradleProjectStructure rootProject = gradleBuild.getRootProject();
            TreeItem rootTreeItem = new TreeItem(ProjectPreviewWizardPage.this.projectPreviewTree, 0);
            rootTreeItem.setExpanded(true);
            rootTreeItem.setText(rootProject.getName());
            this.populateRecursively(rootProject, rootTreeItem);
            for (OmniGradleBuild includedBuilds : gradleBuild.getIncludedBuilds()) {
                this.populateRecursively(includedBuilds, parent);
            }
        }

        private void populateRecursively(OmniGradleProjectStructure gradleProjectStructure, TreeItem parent) {
            for (OmniGradleProjectStructure childProject : gradleProjectStructure.getChildren()) {
                TreeItem treeItem = new TreeItem(parent, 0);
                treeItem.setText(childProject.getName());
                this.populateRecursively(childProject, treeItem);
            }
        }
    }

    public static interface ProjectPreviewLoader {
        public Job loadPreview(FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuild>> var1, List<ProgressListener> var2);
    }
}

