/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.traceability.config;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ExtendedTraceabilityConfiguration;
import org.polarsys.capella.core.transition.system.handlers.traceability.RealizationLinkTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.ReconciliationTraceabilityHandler;
import org.polarsys.capella.core.transition.system.helpers.ContextHelper;
import org.polarsys.capella.transition.system2subsystem.context.SubSystemContextHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.traceability.SIDTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeSourceConfiguration
extends ExtendedTraceabilityConfiguration {
    protected String getExtensionIdentifier(IContext context) {
        return "sourceTraceabilityConfiguration";
    }

    protected void initHandlers(IContext context) {
        this.addHandler(context, (ITraceabilityHandler)new SourceReconciliationTraceabilityHandler(this.getIdentifier(context)));
        this.addHandler(context, (ITraceabilityHandler)new SourceSIDTraceabilityHandler(this.getIdentifier(context)));
    }

    public boolean useHandlerForAttachment(EObject source_p, EObject target_p, ITraceabilityHandler handler_p, IContext context_p) {
        if (handler_p instanceof ReconciliationTraceabilityHandler) {
            return false;
        }
        return super.useHandlerForAttachment(source_p, target_p, handler_p, context_p);
    }

    public boolean useHandlerForTracedElements(EObject source_p, ITraceabilityHandler handler_p, IContext context_p) {
        boolean result = super.useHandlerForTracedElements(source_p, handler_p, context_p);
        if (result && handler_p instanceof RealizationLinkTraceabilityHandler) {
            if (source_p instanceof SystemEngineering) {
                result = false;
            } else if (source_p instanceof BlockArchitecture) {
                result = false;
            }
        }
        return result;
    }

    public boolean useHandlerForSourceElements(EObject source_p, ITraceabilityHandler handler_p, IContext context_p) {
        boolean result = super.useHandlerForSourceElements(source_p, handler_p, context_p);
        if (result && handler_p instanceof RealizationLinkTraceabilityHandler) {
            if (source_p instanceof SystemEngineering) {
                result = false;
            } else if (source_p instanceof BlockArchitecture) {
                result = false;
            }
        }
        return result;
    }

    protected class SourceReconciliationTraceabilityHandler
    extends ReconciliationTraceabilityHandler {
        public SourceReconciliationTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected void initializeBlockArchitecture(BlockArchitecture source, BlockArchitecture target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            super.initializeBlockArchitecture(source, target, context, map);
            Component sourceComponent = BlockArchitectureExt.getOrCreateSystem((BlockArchitecture)source);
            Component targetComponent = BlockArchitectureExt.getOrCreateSystem((BlockArchitecture)target);
            if (sourceComponent != null && targetComponent != null && !map.contains((Object)sourceComponent) && !map.contains((Object)targetComponent)) {
                this.addMapping((MappingTraceability)map, (EObject)sourceComponent, (EObject)targetComponent, context);
            }
        }

        protected void initializeRootMappings(IContext context) {
            ModelInformation transformedInfo;
            super.initializeRootMappings(context);
            this.addMappings((EObject)ContextHelper.getSourceProject((IContext)context), (EObject)ContextHelper.getTransformedProject((IContext)context), context);
            this.addMappings((EObject)ContextHelper.getSourceEngineering((IContext)context), ContextHelper.getTransformedEngineering((IContext)context), context);
            ModelInformation srcInfo = SubSystemContextHelper.getSourceModelInformation(context);
            if (srcInfo != null && (transformedInfo = SubSystemContextHelper.getTransformedModelInformation(context)) != null) {
                this.addMappings((EObject)srcInfo, (EObject)transformedInfo, context);
            }
        }
    }

    protected class SourceSIDTraceabilityHandler
    extends SIDTraceabilityHandler {
        public SourceSIDTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            this.initializeMappings((EObject)ContextHelper.getSourceProject((IContext)context), (EObject)ContextHelper.getTransformedProject((IContext)context), context);
        }
    }
}

