/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;

public class ChainHelper {
    public static <T> boolean equalsUnordered(Collection<T> o, Collection<T> r) {
        HashSet<T> result = new HashSet<T>(o);
        result.retainAll(r);
        return result.size() == o.size() && result.size() == r.size();
    }

    public static <T> Collection<String> toName(Collection<T> arrayList) {
        return arrayList.stream().map(fcr -> ChainHelper.getName(fcr)).collect(Collectors.toList());
    }

    public static <T> String toListString(Collection<T> arrayList) {
        return arrayList.stream().map(fcr -> ChainHelper.getName(fcr)).collect(Collectors.joining("/"));
    }

    public static <T> String getName(T obj) {
        if (obj instanceof FunctionalChain) {
            return ((FunctionalChain)obj).getName();
        }
        return ((FunctionalChain)((FunctionalChainReference)obj).getInvolved()).getName();
    }

    public static boolean referenceSubChain(FunctionalChain chain, FunctionalChain sub) {
        return chain.getOwnedFunctionalChainInvolvements().stream().filter(x -> ChainHelper.referenceSubChain(x, sub)).findFirst().isPresent();
    }

    public static boolean referenceSubChain(FunctionalChainInvolvement f, FunctionalChain sub) {
        return f.getInvolved().equals(sub);
    }

    public static List<FunctionalChainReference> referencingFunctionalChains(FunctionalChain chain, FunctionalChain referencedChain) {
        return chain.getOwnedFunctionalChainInvolvements().stream().filter(FunctionalChainReference.class::isInstance).map(FunctionalChainReference.class::cast).filter(x -> x.getInvolved() == referencedChain).collect(Collectors.toList());
    }

    public static FunctionalChainInvolvementLink referencingFakeExchange(FunctionalChain chain) {
        return (FunctionalChainInvolvementLink)chain.getOwnedFunctionalChainInvolvements().stream().filter(ChainHelper::referenceFakeExchange).findFirst().get();
    }

    public static List<FunctionalChainInvolvementFunction> fcifReferencingFunctions(FunctionalChain chain, AbstractFunction fct) {
        return chain.getOwnedFunctionalChainInvolvements().stream().filter(x -> x.getInvolved() == fct).filter(FunctionalChainInvolvementFunction.class::isInstance).map(FunctionalChainInvolvementFunction.class::cast).collect(Collectors.toList());
    }

    public static List<FunctionalChainInvolvementLink> fcilReferencingFunctions(FunctionalChain chain, AbstractFunction fct) {
        return chain.getOwnedFunctionalChainInvolvements().stream().filter(x -> x.getInvolved() == fct).filter(FunctionalChainInvolvementLink.class::isInstance).map(FunctionalChainInvolvementLink.class::cast).collect(Collectors.toList());
    }

    public static List<FunctionalChainInvolvementLink> referencingFakeExchanges(FunctionalChain chain) {
        return chain.getOwnedFunctionalChainInvolvements().stream().filter(ChainHelper::referenceFakeExchange).map(FunctionalChainInvolvementLink.class::cast).collect(Collectors.toList());
    }

    public static boolean referenceFakeExchange(FunctionalChain chain) {
        return ChainHelper.referencingFakeExchange(chain) != null;
    }

    public static boolean referenceFakeExchange(FunctionalChainInvolvement f) {
        return f instanceof FunctionalChainInvolvementLink && f.getInvolved() instanceof FunctionalExchange && ((FunctionalExchange)f.getInvolved()).getName().contains("Fake");
    }
}

