/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.mixed;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.FunctionalChainAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.tests.System2SubsystemTest;
import org.polarsys.capella.transition.system2subsystem.tests.util.ChainHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class CycleMerge
extends System2SubsystemTest
implements System2SubsystemTest.Interphase,
System2SubsystemTest.Crossphase {
    public static final String FC2 = "d4f83a9f-552f-4f17-bf1c-6821d36d7ba3";
    public static final String PF6 = "e6e6352b-0879-42ad-96d2-f61eb6cba194";
    public static final String PC_1 = "402726dd-45f4-4ab6-b910-9061e6b37d81";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PF3 = "c5fc215b-ea7b-4b1f-98b5-60dd73dc70a5";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PF4 = "d2762ac2-d5a2-4ed6-9848-290e488eb435";

    @Override
    public List<String> getRequiredTestModels() {
        return Arrays.asList("CycleMerge", "output");
    }

    @Override
    protected Collection<?> getProjectionElements() {
        return Collections.singleton(this.getObject(PC_1));
    }

    @Override
    protected void verify() {
        FunctionalChain fc = (FunctionalChain)this.mustBeTransitioned(FC2);
        CycleMerge.assertTrue((fc.getOwnedFunctionalChainInvolvements().size() == 15 ? 1 : 0) != 0);
        TransitionContext context = ChainHelper.createBasicContext();
        FunctionalChainAttachmentHelper helper = new FunctionalChainAttachmentHelper(){

            protected Collection<FunctionalChain> getChainsToAnalyse(FunctionalChain element, IContext context_p) {
                BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
                return FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture);
            }
        };
        Collection<String> paths = ChainHelper.pathsToString(helper.getNextPathsTowards((FunctionalChainInvolvement)this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PF3), (FunctionalChainInvolvement)this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PF4), (IContext)context));
        CycleMerge.assertTrue((boolean)paths.contains("PF3/FE2/PF4/FE3/PF6/FE4/PF1/FE5/PF6/FE6/PF5/FE8/PF4/FE3/PF6/FE4/PF1/FE5/PF6/FE6/PF5/FE8/PF4"));
        CycleMerge.assertTrue((!paths.contains("PF3/FE2/PF4/FE3/PF6/FE4/PF1/FE5/PF6/FE6/PF5/FE8/PF4") ? 1 : 0) != 0);
        CycleMerge.assertTrue((paths.size() == 1 ? 1 : 0) != 0);
    }
}

