/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.embeddededitor.commands;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.RefreshLayoutCommand;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.validation.Issue;
import org.polarsys.capella.common.data.modellingcore.ValueSpecification;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.interaction.services.ExecutionEndExt;
import org.polarsys.capella.core.data.helpers.interaction.services.SequenceMessageExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.data.interaction.AbstractFragment;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.ExecutionEvent;
import org.polarsys.capella.core.data.interaction.FragmentEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionOperatorKind;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.scenario.editor.EmbeddedEditorInstance;
import org.polarsys.capella.scenario.editor.dsl.provider.TextualScenarioProvider;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ArmTimerMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Block;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.CreateMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.DeleteMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Element;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.FoundMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.LostFoundMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.LostMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Message;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Model;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Operand;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Participant;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ParticipantDeactivation;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Reference;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.SequenceMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.SequenceMessageType;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.StateFragment;
import org.polarsys.capella.scenario.editor.embeddededitor.commands.HelperCommands;
import org.polarsys.capella.scenario.editor.embeddededitor.views.EmbeddedEditorView;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;

public class XtextToDiagramCommands {
    public static void process(Scenario scenario, EmbeddedEditorView embeddedEditorViewPart) {
        if (scenario != null) {
            if (embeddedEditorViewPart != null) {
                TextualScenarioProvider p = embeddedEditorViewPart.getProvider();
                XtextResource resource = p.getResource();
                List<Issue> issues = HelperCommands.getValidationIsuesTextResource(resource);
                if (issues.isEmpty()) {
                    EList content = resource.getContents();
                    Model domainModel = (Model)content.get(0);
                    EList participants = domainModel.getParticipants();
                    EList elements = domainModel.getElements();
                    XtextToDiagramCommands.doEditingOnParticipants(scenario, (EList<Participant>)participants);
                    XtextToDiagramCommands.doEditingOnElements(scenario, (EList<Element>)elements);
                } else {
                    HelperCommands.showDialogTextualEditor("Invalid data", "Please fix the errors in the textual editor!" + HelperCommands.getFormattedIssues(issues));
                }
            }
        } else {
            HelperCommands.showDialogTextualEditor("Unknowned scenario", "The associated scenario diagram is unknown!");
        }
    }

    private static void doEditingOnParticipants(final Scenario scenario, final EList<Participant> participants) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)scenario);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                EList instanceRoles = scenario.getOwnedInstanceRoles();
                for (EObject participant : participants) {
                    String instanceName = ((Participant)participant).getName();
                    if (!instanceRoles.stream().filter(ir -> ir.getName().equals(instanceName)).collect(Collectors.toList()).isEmpty()) continue;
                    InstanceRole instanceRole = InteractionFactory.eINSTANCE.createInstanceRole();
                    instanceRole.setName(instanceName);
                    String keyword = ((Participant)participant).getKeyword();
                    EObject capellaParticipant = null;
                    List capellaParticipants = EmbeddedEditorInstanceHelper.getAvailableElements((String)keyword).stream().filter(f -> ((AbstractInstance)f).getName().equals(instanceName)).collect(Collectors.toList());
                    if (!capellaParticipants.isEmpty()) {
                        capellaParticipant = (EObject)capellaParticipants.get(0);
                    }
                    instanceRole.setRepresentedInstance((AbstractInstance)capellaParticipant);
                    instanceRoles.add((Object)instanceRole);
                }
                XtextToDiagramCommands.removeParticipantsFromDiagram(scenario, (EList<Participant>)participants);
                XtextToDiagramCommands.reorderParticipants((List)instanceRoles, (EList<Participant>)participants);
            }
        });
    }

    private static void removeParticipantsFromDiagram(Scenario scenario, EList<Participant> participants) {
        ArrayList<InstanceRole> irToRemove = new ArrayList<InstanceRole>();
        EList instanceRoles = scenario.getOwnedInstanceRoles();
        for (InstanceRole ir : instanceRoles) {
            List participantsName = participants.stream().map(x -> x.getName()).collect(Collectors.toList());
            if (participantsName.contains(ir.getName())) continue;
            irToRemove.add(ir);
            XtextToDiagramCommands.removeParticipantRelatedElements(scenario, ir);
        }
        for (InstanceRole ir : irToRemove) {
            instanceRoles.remove((Object)ir);
        }
    }

    private static void removeParticipantRelatedElements(Scenario scenario, InstanceRole instanceRole) {
        XtextToDiagramCommands.removeParticipantRelatedMessages(scenario, instanceRole.getName());
        XtextToDiagramCommands.removeParticipantRelatedStateFragments(scenario, instanceRole.getName());
        XtextToDiagramCommands.removeParticipantRelatedCombinedFragments(scenario, instanceRole);
    }

    private static boolean reorderParticipants(List<InstanceRole> instanceRoles, EList<Participant> participants) {
        boolean updateNeeded = false;
        int i = 0;
        while (i < instanceRoles.size()) {
            if (!instanceRoles.get(i).getName().equals(((Participant)participants.get(i)).getName())) {
                int j = 0;
                while (j < participants.size()) {
                    if (instanceRoles.get(i).getName().equals(((Participant)participants.get(j)).getName())) {
                        ((EList)instanceRoles).move(j, (Object)instanceRoles.get(i));
                        updateNeeded = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return updateNeeded;
    }

    private static void removeParticipantRelatedMessages(Scenario scenario, String participantName) {
        ArrayList<org.polarsys.capella.core.data.interaction.SequenceMessage> messagesToBeDeleted = new ArrayList<org.polarsys.capella.core.data.interaction.SequenceMessage>();
        EList messages = scenario.getOwnedMessages();
        for (org.polarsys.capella.core.data.interaction.SequenceMessage message : messages) {
            if ((message.getSendingEnd() == null || message.getSendingEnd().getCoveredInstanceRoles().isEmpty() || !((InstanceRole)message.getSendingEnd().getCoveredInstanceRoles().get(0)).getName().equals(participantName)) && (message.getReceivingEnd() == null || message.getReceivingEnd().getCoveredInstanceRoles().isEmpty() || !((InstanceRole)message.getReceivingEnd().getCoveredInstanceRoles().get(0)).getName().equals(participantName))) continue;
            messagesToBeDeleted.add(message);
        }
        for (org.polarsys.capella.core.data.interaction.SequenceMessage message : messagesToBeDeleted) {
            XtextToDiagramCommands.removeMessageFromScenario(scenario, message);
        }
    }

    protected static void removeParticipantRelatedStateFragments(Scenario scenario, String participantName) {
        List stateFragmentsToBeDeleted = scenario.getOwnedTimeLapses().stream().filter(timelapse -> timelapse instanceof org.polarsys.capella.core.data.interaction.StateFragment && ((InstanceRole)timelapse.getStart().getCoveredInstanceRoles().get(0)).getName().equals(participantName)).collect(Collectors.toList());
        for (TimeLapse timeLapse : stateFragmentsToBeDeleted) {
            XtextToDiagramCommands.removeStateFragmentFromScenario(scenario, timeLapse);
        }
    }

    private static void removeParticipantRelatedCombinedFragments(Scenario scenario, InstanceRole instanceRole) {
        List combinedFragmentsToBeDeleted = scenario.getOwnedTimeLapses().stream().filter(timelapse -> timelapse instanceof CombinedFragment && timelapse.getStart().getCoveredInstanceRoles().contains((Object)instanceRole)).collect(Collectors.toList());
        for (TimeLapse timeLapse : combinedFragmentsToBeDeleted) {
            XtextToDiagramCommands.removeCombinedFragmentFromScenario(scenario, timeLapse);
        }
    }

    private static void syncGraphicalOrdering() {
        DDiagram dDiagram = EmbeddedEditorInstance.getDDiagram();
        ((SequenceDDiagram)dDiagram).getTarget();
        EList ownedAnnotationEntries = dDiagram.getOwnedAnnotationEntries();
        Diagram diagram = null;
        for (AnnotationEntry annotationEntry : ownedAnnotationEntries) {
            if (annotationEntry == null || !(annotationEntry.getData() instanceof Diagram)) continue;
            diagram = (Diagram)annotationEntry.getData();
            break;
        }
        if (diagram != null) {
            RefreshLayoutCommand refreshLayoutCommand = new RefreshLayoutCommand(TransactionUtil.getEditingDomain((EObject)dDiagram), diagram, true);
            refreshLayoutCommand.execute();
            EmbeddedEditorInstanceHelper.refreshAssociatedDiagram();
        }
    }

    private static void doEditingOnElements(final Scenario scenario, final EList<Element> elements) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)scenario);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                XtextToDiagramCommands.cleanUp(scenario, (List)elements);
                ArrayList processedCapellaMessages = new ArrayList();
                ArrayList processedCapellaCombinedFragments = new ArrayList();
                ArrayList processedStateFragments = new ArrayList();
                ArrayList processedReferences = new ArrayList();
                XtextToDiagramCommands.editElements(scenario, (EList<Element>)elements, processedCapellaMessages, processedCapellaCombinedFragments, processedStateFragments, processedReferences);
                this.reorderCapellaScenario(scenario, (EList<Element>)elements);
                XtextToDiagramCommands.syncGraphicalOrdering();
            }

            private void reorderCapellaScenario(Scenario scenario2, EList<Element> elements2) {
                ArrayList<org.polarsys.capella.core.data.interaction.SequenceMessage> capellaSequenceMessages = new ArrayList<org.polarsys.capella.core.data.interaction.SequenceMessage>();
                ArrayList<InteractionFragment> interactionFragments = new ArrayList<InteractionFragment>();
                ArrayList<InteractionFragment> executionEndsToProcess = new ArrayList<InteractionFragment>();
                ArrayList<org.polarsys.capella.core.data.interaction.SequenceMessage> processedCapellaMessages = new ArrayList<org.polarsys.capella.core.data.interaction.SequenceMessage>();
                ArrayList<CombinedFragment> processedCapellaCombinedFragments = new ArrayList<CombinedFragment>();
                this.reorderCapellaFragments(scenario2, elements2, capellaSequenceMessages, interactionFragments, executionEndsToProcess, processedCapellaMessages, processedCapellaCombinedFragments);
                this.createListFromNewList(scenario2.getOwnedInteractionFragments(), interactionFragments);
                this.createListFromNewList(scenario2.getOwnedMessages(), capellaSequenceMessages);
            }

            private void createListFromNewList(EList originalList, List<? extends EObject> newList) {
                originalList.removeIf(elem -> !newList.contains(elem));
                int newIndex = 0;
                while (newIndex < newList.size()) {
                    EObject newElement = newList.get(newIndex);
                    int oldIndex = originalList.indexOf((Object)newElement);
                    if (oldIndex < 0) {
                        if (originalList.size() > newIndex) {
                            originalList.add(newIndex, (Object)newElement);
                        } else {
                            originalList.add((Object)newElement);
                        }
                    } else if (oldIndex != newIndex && originalList.size() > newIndex) {
                        originalList.move(newIndex, oldIndex);
                    }
                    ++newIndex;
                }
            }

            private void reorderCapellaFragments(Scenario scenario2, EList<Element> elements2, List<org.polarsys.capella.core.data.interaction.SequenceMessage> capellaSequenceMessages, List<InteractionFragment> interactionFragments, List<InteractionFragment> executionEndsToProcess, List<org.polarsys.capella.core.data.interaction.SequenceMessage> processedCapellaMessages, ArrayList<CombinedFragment> processedCapellaCombinedFragments) {
                for (EObject elementFromXtext : elements2) {
                    InteractionUse reference;
                    if (elementFromXtext instanceof ParticipantDeactivation) {
                        this.reorderCapellaDeactivationMessages((ParticipantDeactivation)elementFromXtext, interactionFragments, capellaSequenceMessages, executionEndsToProcess);
                        continue;
                    }
                    if (elementFromXtext instanceof Message) {
                        this.reorderCapellaSequenceMessages(scenario2, (Message)elementFromXtext, interactionFragments, capellaSequenceMessages, executionEndsToProcess, processedCapellaMessages);
                        continue;
                    }
                    if (elementFromXtext instanceof org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment) {
                        org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment textCombinedFragment = (org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)elementFromXtext;
                        CombinedFragment capellaCombinedFragment = XtextToDiagramCommands.getCorrespondingCapellaCombinedFragment(scenario2, textCombinedFragment, processedCapellaCombinedFragments);
                        if (capellaCombinedFragment == null) continue;
                        interactionFragments.add(capellaCombinedFragment.getStart());
                        List orderedCapellaOperands = XtextToDiagramCommands.getOrderedCapellaInteractionOperands(scenario2, textCombinedFragment, capellaCombinedFragment);
                        interactionFragments.add((InteractionFragment)orderedCapellaOperands.get(0));
                        this.reorderCapellaFragments(scenario2, (EList<Element>)textCombinedFragment.getBlock().getBlockElements(), capellaSequenceMessages, interactionFragments, executionEndsToProcess, processedCapellaMessages, processedCapellaCombinedFragments);
                        EList textOperands = textCombinedFragment.getOperands();
                        int i = 0;
                        while (i < textOperands.size()) {
                            InteractionOperand operand = (InteractionOperand)orderedCapellaOperands.get(i + 1);
                            interactionFragments.add((InteractionFragment)operand);
                            this.reorderCapellaFragments(scenario2, (EList<Element>)((Operand)textOperands.get(i)).getBlock().getBlockElements(), capellaSequenceMessages, interactionFragments, executionEndsToProcess, processedCapellaMessages, processedCapellaCombinedFragments);
                            ++i;
                        }
                        interactionFragments.add(capellaCombinedFragment.getFinish());
                        continue;
                    }
                    if (elementFromXtext instanceof StateFragment) {
                        org.polarsys.capella.core.data.interaction.StateFragment stateFragment = XtextToDiagramCommands.getCorrespondingCapellaStateFragment(scenario2, interactionFragments, (StateFragment)elementFromXtext);
                        if (stateFragment == null) continue;
                        interactionFragments.add(stateFragment.getStart());
                        interactionFragments.add(stateFragment.getFinish());
                        continue;
                    }
                    if (!(elementFromXtext instanceof Reference) || (reference = XtextToDiagramCommands.getCorrespondingCapellaReference(scenario2, (Reference)elementFromXtext, interactionFragments)) == null) continue;
                    interactionFragments.add(reference.getStart());
                    interactionFragments.add(reference.getFinish());
                }
            }

            private void reorderCapellaDeactivationMessages(ParticipantDeactivation participantDeactivationMessage, List<InteractionFragment> interactionFragments, List<org.polarsys.capella.core.data.interaction.SequenceMessage> capellaSequenceMessages, List<InteractionFragment> executionEndsToProcess) {
                InstanceRole instanceRole = EmbeddedEditorInstanceHelper.getInstanceRole((String)participantDeactivationMessage.getName());
                XtextToDiagramCommands.doDeactivationSequenceMessageForReorder(interactionFragments, instanceRole, executionEndsToProcess, capellaSequenceMessages);
            }

            private void reorderCapellaSequenceMessages(Scenario scenario2, Message elementFromXtext, List<InteractionFragment> interactionFragments, List<org.polarsys.capella.core.data.interaction.SequenceMessage> capellaSequenceMessages, List<InteractionFragment> executionEndsToProcess, List<org.polarsys.capella.core.data.interaction.SequenceMessage> processedCapellaMessages) {
                org.polarsys.capella.core.data.interaction.SequenceMessage capellaSequenceMessage;
                if (this.foundInstanceRolesOnMessageEnds(elementFromXtext) && (capellaSequenceMessage = XtextToDiagramCommands.getCorrespondingCapellaSequenceMessage(scenario2, elementFromXtext, processedCapellaMessages)) != null) {
                    capellaSequenceMessages.add(capellaSequenceMessage);
                    if (capellaSequenceMessage.getSendingEnd() != null) {
                        interactionFragments.add((InteractionFragment)capellaSequenceMessage.getSendingEnd());
                    }
                    if (capellaSequenceMessage.getReceivingEnd() != null) {
                        interactionFragments.add((InteractionFragment)capellaSequenceMessage.getReceivingEnd());
                    }
                    if (!capellaSequenceMessage.getKind().equals((Object)MessageKind.CREATE) && !capellaSequenceMessage.getKind().equals((Object)MessageKind.DELETE)) {
                        Execution execution = XtextToDiagramCommands.getExecutionForSequenceMessage(scenario2, capellaSequenceMessage);
                        if (!XtextToDiagramCommands.hasExecution(elementFromXtext)) {
                            if (!XtextToDiagramCommands.hasReturn(elementFromXtext)) {
                                if (execution != null) {
                                    interactionFragments.add(execution.getFinish());
                                }
                            } else {
                                org.polarsys.capella.core.data.interaction.SequenceMessage capellaReturnSequenceMessage = SequenceMessageExt.getOppositeSequenceMessage((org.polarsys.capella.core.data.interaction.SequenceMessage)capellaSequenceMessage);
                                if (capellaReturnSequenceMessage == null) {
                                    capellaReturnSequenceMessage = SequenceMessageExt.findReplySequenceMessage((org.polarsys.capella.core.data.interaction.SequenceMessage)capellaSequenceMessage);
                                }
                                interactionFragments.add((InteractionFragment)capellaReturnSequenceMessage.getSendingEnd());
                                interactionFragments.add((InteractionFragment)capellaReturnSequenceMessage.getReceivingEnd());
                                capellaSequenceMessages.add(capellaReturnSequenceMessage);
                            }
                        } else if (execution != null) {
                            executionEndsToProcess.add(execution.getFinish());
                        }
                    }
                }
            }

            private boolean foundInstanceRolesOnMessageEnds(Message elementFromXtext) {
                if (elementFromXtext instanceof SequenceMessageType) {
                    InstanceRole source = EmbeddedEditorInstanceHelper.getInstanceRole((String)((SequenceMessageType)elementFromXtext).getSource());
                    InstanceRole target = EmbeddedEditorInstanceHelper.getInstanceRole((String)((SequenceMessageType)elementFromXtext).getTarget());
                    return source != null && target != null;
                }
                if (elementFromXtext instanceof ArmTimerMessage) {
                    InstanceRole timeline = EmbeddedEditorInstanceHelper.getInstanceRole((String)((ArmTimerMessage)elementFromXtext).getParticipant());
                    return timeline != null;
                }
                if (elementFromXtext instanceof LostMessage) {
                    InstanceRole timeline = EmbeddedEditorInstanceHelper.getInstanceRole((String)((LostMessage)elementFromXtext).getSource());
                    return timeline != null;
                }
                if (elementFromXtext instanceof FoundMessage) {
                    InstanceRole timeline = EmbeddedEditorInstanceHelper.getInstanceRole((String)((FoundMessage)elementFromXtext).getTarget());
                    return timeline != null;
                }
                return false;
            }
        });
    }

    private static void editElements(Scenario scenario, EList<Element> elements, List<org.polarsys.capella.core.data.interaction.SequenceMessage> processedCapellaMessages, ArrayList<CombinedFragment> processedCapellaCombinedFragments, ArrayList<StateFragment> previousStateFragments, ArrayList<Reference> previousReferences) {
        EList capellaSequenceMessages = scenario.getOwnedMessages();
        for (EObject xtextElement : elements) {
            if (xtextElement instanceof Message && !(xtextElement instanceof ParticipantDeactivation)) {
                Message xtextSeqMessage = (Message)xtextElement;
                InstanceRole source = null;
                InstanceRole target = null;
                if (xtextSeqMessage instanceof SequenceMessageType) {
                    source = EmbeddedEditorInstanceHelper.getInstanceRole((String)((SequenceMessageType)xtextSeqMessage).getSource());
                    target = EmbeddedEditorInstanceHelper.getInstanceRole((String)((SequenceMessageType)xtextSeqMessage).getTarget());
                } else if (xtextSeqMessage instanceof LostMessage) {
                    source = EmbeddedEditorInstanceHelper.getInstanceRole((String)((LostMessage)xtextSeqMessage).getSource());
                } else if (xtextSeqMessage instanceof FoundMessage) {
                    target = EmbeddedEditorInstanceHelper.getInstanceRole((String)((FoundMessage)xtextSeqMessage).getTarget());
                } else if (xtextSeqMessage instanceof ArmTimerMessage) {
                    target = source = EmbeddedEditorInstanceHelper.getInstanceRole((String)((ArmTimerMessage)xtextSeqMessage).getParticipant());
                }
                if (XtextToDiagramCommands.foundMatchingCapellaMessage((EList<org.polarsys.capella.core.data.interaction.SequenceMessage>)capellaSequenceMessages, xtextSeqMessage, processedCapellaMessages)) continue;
                org.polarsys.capella.core.data.interaction.SequenceMessage sequenceMessage = XtextToDiagramCommands.createCapellaSequenceMessage(scenario, source, target, xtextSeqMessage);
                capellaSequenceMessages.add((Object)sequenceMessage);
                processedCapellaMessages.add(sequenceMessage);
                if (source == null || target == null || !XtextToDiagramCommands.hasReturn(xtextSeqMessage)) continue;
                org.polarsys.capella.core.data.interaction.SequenceMessage opposingSequenceMessage = XtextToDiagramCommands.createCapellaSequenceMessage(scenario, target, source, xtextSeqMessage, true);
                Execution execution = XtextToDiagramCommands.getExecutionForSequenceMessage(scenario, sequenceMessage);
                if (execution != null) {
                    execution.setFinish((InteractionFragment)opposingSequenceMessage.getSendingEnd());
                }
                capellaSequenceMessages.add((Object)opposingSequenceMessage);
                continue;
            }
            if (xtextElement instanceof org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment) {
                CombinedFragment capellaFragment = XtextToDiagramCommands.getCorrespondingCapellaCombinedFragment(scenario, (org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)xtextElement, processedCapellaCombinedFragments);
                if (capellaFragment == null) {
                    MessageEnd lastInteractionFragment = null;
                    if (!capellaSequenceMessages.isEmpty()) {
                        org.polarsys.capella.core.data.interaction.SequenceMessage lastSequenceMessage = (org.polarsys.capella.core.data.interaction.SequenceMessage)capellaSequenceMessages.get(capellaSequenceMessages.size() - 1);
                        lastInteractionFragment = lastSequenceMessage.getReceivingEnd();
                    }
                    XtextToDiagramCommands.createCapellaCombinedFragmentBlock(scenario, (org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)xtextElement, lastInteractionFragment, processedCapellaMessages, processedCapellaCombinedFragments, previousStateFragments, previousReferences);
                    continue;
                }
                XtextToDiagramCommands.editElements(scenario, (EList<Element>)((org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)xtextElement).getBlock().getBlockElements(), processedCapellaMessages, processedCapellaCombinedFragments, previousStateFragments, previousReferences);
                for (Operand operand : ((org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)xtextElement).getOperands()) {
                    XtextToDiagramCommands.editElements(scenario, (EList<Element>)operand.getBlock().getBlockElements(), processedCapellaMessages, processedCapellaCombinedFragments, previousStateFragments, previousReferences);
                }
                continue;
            }
            if (xtextElement instanceof StateFragment) {
                previousStateFragments.add((StateFragment)xtextElement);
                XtextToDiagramCommands.editStateFragment(scenario, (StateFragment)xtextElement, previousStateFragments);
                continue;
            }
            if (!(xtextElement instanceof Reference)) continue;
            previousReferences.add((Reference)xtextElement);
            XtextToDiagramCommands.editReference(scenario, (Reference)xtextElement, previousReferences);
        }
    }

    private static void cleanUp(Scenario scenario, List<Element> elements) {
        ArrayList<Element> allXtextElements = new ArrayList<Element>();
        XtextToDiagramCommands.getAllXtextElements(elements, allXtextElements);
        XtextToDiagramCommands.cleanUpMessages(scenario, allXtextElements);
        XtextToDiagramCommands.cleanUpStateFragments(scenario, allXtextElements);
        XtextToDiagramCommands.cleanUpCombinedFragments(scenario, allXtextElements);
        XtextToDiagramCommands.cleanUpReferences(scenario, allXtextElements);
    }

    private static boolean foundMatchingCapellaMessage(EList<org.polarsys.capella.core.data.interaction.SequenceMessage> capellaSequenceMessages, Message seqMessage, List<org.polarsys.capella.core.data.interaction.SequenceMessage> processedCapellaMessages) {
        List matchingMessages = capellaSequenceMessages.stream().filter(x -> !processedCapellaMessages.contains(x) && XtextToDiagramCommands.isSameMessage((EObject)seqMessage, x)).collect(Collectors.toList());
        if (!matchingMessages.isEmpty()) {
            processedCapellaMessages.add((org.polarsys.capella.core.data.interaction.SequenceMessage)matchingMessages.get(0));
            return true;
        }
        return false;
    }

    private static boolean hasReturn(Message elementFromXtext) {
        if (elementFromXtext instanceof SequenceMessage) {
            return ((SequenceMessage)elementFromXtext).getReturn() != null;
        }
        return false;
    }

    protected static boolean hasExecution(Message elementFromXtext) {
        if (elementFromXtext instanceof SequenceMessage) {
            return ((SequenceMessage)elementFromXtext).getExecution() != null;
        }
        if (elementFromXtext instanceof ArmTimerMessage) {
            return ((ArmTimerMessage)elementFromXtext).getExecution() != null;
        }
        if (elementFromXtext instanceof FoundMessage) {
            return ((FoundMessage)elementFromXtext).getExecution() != null;
        }
        return false;
    }

    private static void editStateFragment(Scenario scenario, StateFragment xtextElement, List<StateFragment> previousEditorStateFragments) {
        InstanceRole instanceRole = EmbeddedEditorInstanceHelper.getInstanceRole((String)xtextElement.getTimeline());
        EList ownedTimeLapses = scenario.getOwnedTimeLapses();
        List simillarStateFragments = previousEditorStateFragments.stream().filter(x -> x.getTimeline().equals(xtextElement.getTimeline()) && x.getName().equals(xtextElement.getName()) && x.getKeyword().equals(xtextElement.getKeyword())).collect(Collectors.toList());
        EObject relatedElement = XtextToDiagramCommands.getRelatedElement(instanceRole, xtextElement);
        if (relatedElement == null) {
            return;
        }
        List<TimeLapse> capellaStateFragments = XtextToDiagramCommands.getStateFragmentsWithGivenAttributes(scenario, instanceRole, xtextElement, relatedElement);
        if (capellaStateFragments.isEmpty() || capellaStateFragments.size() < simillarStateFragments.size()) {
            InteractionState interactionStateStart = XtextToDiagramCommands.createInteractionState("start", relatedElement, instanceRole);
            InteractionState interactionStateEnd = XtextToDiagramCommands.createInteractionState("finish", relatedElement, instanceRole);
            scenario.getOwnedInteractionFragments().add((Object)interactionStateStart);
            scenario.getOwnedInteractionFragments().add((Object)interactionStateEnd);
            org.polarsys.capella.core.data.interaction.StateFragment stateFragment = XtextToDiagramCommands.createStateFragment(interactionStateStart, interactionStateEnd, relatedElement);
            ownedTimeLapses.add((Object)stateFragment);
        }
    }

    private static List<TimeLapse> getStateFragmentsWithGivenAttributes(Scenario scenario, InstanceRole instanceRole, StateFragment xtextElement, EObject relatedElement) {
        if (xtextElement.getKeyword().equals("function")) {
            return scenario.getOwnedTimeLapses().stream().filter(x -> x instanceof org.polarsys.capella.core.data.interaction.StateFragment && relatedElement.equals(((org.polarsys.capella.core.data.interaction.StateFragment)x).getRelatedAbstractFunction()) && ((InstanceRole)((org.polarsys.capella.core.data.interaction.StateFragment)x).getStart().getCoveredInstanceRoles().get(0)).equals(instanceRole)).collect(Collectors.toList());
        }
        return scenario.getOwnedTimeLapses().stream().filter(x -> x instanceof org.polarsys.capella.core.data.interaction.StateFragment && relatedElement.equals(((org.polarsys.capella.core.data.interaction.StateFragment)x).getRelatedAbstractState()) && ((InstanceRole)((org.polarsys.capella.core.data.interaction.StateFragment)x).getStart().getCoveredInstanceRoles().get(0)).equals(instanceRole)).collect(Collectors.toList());
    }

    private static EObject getRelatedElement(InstanceRole instanceRole, StateFragment stateFragment) {
        if (stateFragment.getKeyword().equals("function")) {
            return XtextToDiagramCommands.getCorrespondingCapellaAbstractFunction(instanceRole, stateFragment.getName());
        }
        return XtextToDiagramCommands.getCorrespondingCapellaAbstractState(instanceRole, stateFragment.getName(), stateFragment.getKeyword());
    }

    private static org.polarsys.capella.core.data.interaction.StateFragment createStateFragment(InteractionState interactionStateStart, InteractionState interactionStateEnd, EObject relatedElement) {
        org.polarsys.capella.core.data.interaction.StateFragment stateFragment = InteractionFactory.eINSTANCE.createStateFragment();
        stateFragment.setStart((InteractionFragment)interactionStateStart);
        stateFragment.setFinish((InteractionFragment)interactionStateEnd);
        if (relatedElement instanceof AbstractFunction) {
            stateFragment.setRelatedAbstractFunction((AbstractFunction)relatedElement);
        } else {
            stateFragment.setRelatedAbstractState((AbstractState)relatedElement);
        }
        return stateFragment;
    }

    private static InteractionState createInteractionState(String name, EObject relatedElement, InstanceRole instanceRole) {
        InteractionState interactionState = InteractionFactory.eINSTANCE.createInteractionState();
        interactionState.setName(name);
        interactionState.getCoveredInstanceRoles().add((Object)instanceRole);
        if (relatedElement instanceof AbstractFunction) {
            interactionState.setRelatedAbstractFunction((AbstractFunction)relatedElement);
        } else {
            interactionState.setRelatedAbstractState((AbstractState)relatedElement);
        }
        return interactionState;
    }

    private static AbstractFunction getCorrespondingCapellaAbstractFunction(InstanceRole instanceRole, String name) {
        List availableFunctions = EmbeddedEditorInstanceHelper.getAllocatedFunctions((InstanceRole)instanceRole);
        for (AbstractFunction availableFunction : availableFunctions) {
            if (!availableFunction.getName().equals(name)) continue;
            return availableFunction;
        }
        return null;
    }

    private static AbstractState getCorrespondingCapellaAbstractState(InstanceRole instanceRole, String name, String keyword) {
        List availableStates = keyword.equals("state") ? EmbeddedEditorInstanceHelper.getStates((InstanceRole)instanceRole) : EmbeddedEditorInstanceHelper.getModes((InstanceRole)instanceRole);
        for (AbstractState availableState : availableStates) {
            if (!availableState.getName().equals(name)) continue;
            return availableState;
        }
        return null;
    }

    private static Execution getExecutionForSequenceMessage(Scenario scenario, org.polarsys.capella.core.data.interaction.SequenceMessage sequenceMessage) {
        Execution execution = null;
        MessageEnd receivingEnd = sequenceMessage.getReceivingEnd();
        for (TimeLapse timeLapse : scenario.getOwnedTimeLapses()) {
            Execution exec;
            if (!(timeLapse instanceof Execution) || (exec = (Execution)timeLapse).getStart() == null || !exec.getStart().equals(receivingEnd)) continue;
            execution = exec;
        }
        return execution;
    }

    private static org.polarsys.capella.core.data.interaction.SequenceMessage getCorrespondingCapellaSequenceMessage(Scenario scenario, Message elementFromXtext, List<org.polarsys.capella.core.data.interaction.SequenceMessage> processedCapellaMessages) {
        EList sequenceMessages = scenario.getOwnedMessages();
        for (org.polarsys.capella.core.data.interaction.SequenceMessage sm : sequenceMessages) {
            if (processedCapellaMessages.contains(sm) || !XtextToDiagramCommands.isSameMessage((EObject)elementFromXtext, sm)) continue;
            processedCapellaMessages.add(sm);
            return sm;
        }
        return null;
    }

    private static InteractionOperand getCapellaInteractionOperand(Scenario scenario, Operand textOperandBlock, CombinedFragment capellaCombinedFragment, List<InteractionOperand> processedOperands) {
        EList combinedFragmentOperands = capellaCombinedFragment.getReferencedOperands();
        for (InteractionOperand operand : combinedFragmentOperands) {
            if (processedOperands.contains(operand) || !XtextToDiagramCommands.isSameExpression(HelperCommands.getExpressionText(operand), textOperandBlock.getExpression())) continue;
            processedOperands.add(operand);
            return operand;
        }
        return null;
    }

    private static InteractionOperand getFirstCapellaInteractionOperand(Scenario scenario, org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment textCombinedFragment, CombinedFragment capellaCombinedFragment) {
        EList combinedFragmentOperands = capellaCombinedFragment.getReferencedOperands();
        for (InteractionOperand operand : combinedFragmentOperands) {
            if (!XtextToDiagramCommands.isSameExpression(HelperCommands.getExpressionText(operand), textCombinedFragment.getExpression())) continue;
            return operand;
        }
        return null;
    }

    private static List<InteractionOperand> getOrderedCapellaInteractionOperands(Scenario scenario, org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment textCombinedFragment, CombinedFragment capellaCombinedFragment) {
        ArrayList<InteractionOperand> orderedOperands = new ArrayList<InteractionOperand>(1 + textCombinedFragment.getOperands().size());
        orderedOperands.add(XtextToDiagramCommands.getFirstCapellaInteractionOperand(scenario, textCombinedFragment, capellaCombinedFragment));
        ArrayList<InteractionOperand> processedOperands = new ArrayList<InteractionOperand>();
        processedOperands.add((InteractionOperand)orderedOperands.get(0));
        for (Operand textOperandBlock : textCombinedFragment.getOperands()) {
            orderedOperands.add(XtextToDiagramCommands.getCapellaInteractionOperand(scenario, textOperandBlock, capellaCombinedFragment, processedOperands));
        }
        return orderedOperands;
    }

    private static org.polarsys.capella.core.data.interaction.StateFragment getCorrespondingCapellaStateFragment(Scenario scenario, List<InteractionFragment> interactionFragments, StateFragment stateFragment) {
        InstanceRole instanceRole = EmbeddedEditorInstanceHelper.getInstanceRole((String)stateFragment.getTimeline());
        List filteredTimeLapses = stateFragment.getKeyword().equals("function") ? scenario.getOwnedTimeLapses().stream().filter(x -> x instanceof org.polarsys.capella.core.data.interaction.StateFragment && ((org.polarsys.capella.core.data.interaction.StateFragment)x).getRelatedAbstractFunction() != null && ((org.polarsys.capella.core.data.interaction.StateFragment)x).getRelatedAbstractFunction().getName().equals(stateFragment.getName()) && ((InstanceRole)x.getStart().getCoveredInstanceRoles().get(0)).equals(instanceRole) && !interactionFragments.contains(((org.polarsys.capella.core.data.interaction.StateFragment)x).getStart())).collect(Collectors.toList()) : scenario.getOwnedTimeLapses().stream().filter(x -> x instanceof org.polarsys.capella.core.data.interaction.StateFragment && ((org.polarsys.capella.core.data.interaction.StateFragment)x).getRelatedAbstractState() != null && ((org.polarsys.capella.core.data.interaction.StateFragment)x).getRelatedAbstractState().getName().equals(stateFragment.getName()) && ((InstanceRole)x.getStart().getCoveredInstanceRoles().get(0)).equals(instanceRole) && !interactionFragments.contains(((org.polarsys.capella.core.data.interaction.StateFragment)x).getStart())).collect(Collectors.toList());
        if (!filteredTimeLapses.isEmpty()) {
            return (org.polarsys.capella.core.data.interaction.StateFragment)filteredTimeLapses.get(0);
        }
        return null;
    }

    private static CombinedFragment getCorrespondingCapellaCombinedFragment(Scenario scenario, org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment textCombinedFragment, ArrayList<CombinedFragment> processedCapellaCombinedFragments) {
        EList fragments = scenario.getOwnedInteractionFragments();
        for (InteractionFragment element : fragments) {
            EList capellaOperands;
            if (!(element instanceof FragmentEnd)) continue;
            AbstractFragment abstractFragment = ((FragmentEnd)element).getAbstractFragment();
            CombinedFragment candidateCombinedFragment = null;
            if (abstractFragment instanceof CombinedFragment) {
                candidateCombinedFragment = (CombinedFragment)abstractFragment;
            }
            if (candidateCombinedFragment == null || processedCapellaCombinedFragments.contains(candidateCombinedFragment) || !candidateCombinedFragment.getOperator().toString().equalsIgnoreCase(textCombinedFragment.getKeyword()) || !XtextToDiagramCommands.haveSameTimelines(textCombinedFragment, candidateCombinedFragment) || (capellaOperands = candidateCombinedFragment.getReferencedOperands()).size() != textCombinedFragment.getOperands().size() + 1 || !XtextToDiagramCommands.operandsHaveSameExpressions(textCombinedFragment, (List<InteractionOperand>)capellaOperands)) continue;
            processedCapellaCombinedFragments.add(candidateCombinedFragment);
            return candidateCombinedFragment;
        }
        return null;
    }

    private static boolean haveSameTimelines(org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment textCombinedFragment, CombinedFragment capellaCombinedFragment) {
        EList xtextTimelines = textCombinedFragment.getTimelines();
        List capellaTimelines = capellaCombinedFragment.getStart().getCoveredInstanceRoles().stream().map(role -> role.getName()).collect(Collectors.toList());
        xtextTimelines.sort(Comparator.naturalOrder());
        capellaTimelines.sort(Comparator.naturalOrder());
        return xtextTimelines.equals(capellaTimelines);
    }

    private static boolean operandsHaveSameExpressions(org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment textCombinedFragment, List<InteractionOperand> capellaOperands) {
        InteractionOperand capellaOperand = capellaOperands.get(0);
        boolean operandsHaveSameExpressions = true;
        if (!XtextToDiagramCommands.isSameExpression(HelperCommands.getExpressionText(capellaOperand), textCombinedFragment.getExpression())) {
            operandsHaveSameExpressions = false;
        }
        int i = 1;
        while (i < capellaOperands.size() && operandsHaveSameExpressions) {
            capellaOperand = capellaOperands.get(i);
            Operand xtextOperand = (Operand)textCombinedFragment.getOperands().get(i - 1);
            if (!XtextToDiagramCommands.isSameExpression(HelperCommands.getExpressionText(capellaOperand), xtextOperand.getExpression())) {
                operandsHaveSameExpressions = false;
            }
            ++i;
        }
        return operandsHaveSameExpressions;
    }

    private static void cleanUpMessages(Scenario scenario, List<Element> messages) {
        List<Message> allXtextSequenceMessages = XtextToDiagramCommands.getAllXtextSequenceMessages(messages);
        List<org.polarsys.capella.core.data.interaction.SequenceMessage> messagesToBeDeleted = XtextToDiagramCommands.getCapellaSequenceMessagesToBeDeleted(scenario, allXtextSequenceMessages);
        for (org.polarsys.capella.core.data.interaction.SequenceMessage sequenceMessage : messagesToBeDeleted) {
            XtextToDiagramCommands.removeMessageFromScenario(scenario, sequenceMessage);
        }
    }

    private static List<org.polarsys.capella.core.data.interaction.SequenceMessage> getCapellaSequenceMessagesToBeDeleted(Scenario scenario, List<Message> allXtextSequenceMessages) {
        EList capellaSequenceMessages = scenario.getOwnedMessages();
        ArrayList<Message> processedXtextSequenceMessages = new ArrayList<Message>();
        ArrayList<org.polarsys.capella.core.data.interaction.SequenceMessage> sequenceMessagesToBeDeleted = new ArrayList<org.polarsys.capella.core.data.interaction.SequenceMessage>();
        for (org.polarsys.capella.core.data.interaction.SequenceMessage capellaSequenceMessage : capellaSequenceMessages) {
            if (capellaSequenceMessage.getKind() == MessageKind.REPLY || XtextToDiagramCommands.foundCapellaMessageInXText(capellaSequenceMessage, allXtextSequenceMessages, processedXtextSequenceMessages)) continue;
            sequenceMessagesToBeDeleted.add(capellaSequenceMessage);
        }
        return sequenceMessagesToBeDeleted;
    }

    private static void cleanUpStateFragments(Scenario scenario, List<Element> xTextElements) {
        List<EObject> allXtextStateFragments = xTextElements.stream().filter(element -> element instanceof StateFragment).collect(Collectors.toList());
        List<TimeLapse> stateFragmentsToBeDeleted = XtextToDiagramCommands.getCapellaStateFragmentsToBeDeleted(scenario, allXtextStateFragments);
        for (TimeLapse timeLapse : stateFragmentsToBeDeleted) {
            XtextToDiagramCommands.removeStateFragmentFromScenario(scenario, timeLapse);
        }
    }

    private static void cleanUpCombinedFragments(Scenario scenario, List<Element> xTextElements) {
        List<EObject> allXtextCombinedFragments = xTextElements.stream().filter(element -> element instanceof org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment).collect(Collectors.toList());
        List<TimeLapse> combinedFragmentsToBeDeleted = XtextToDiagramCommands.getCapellaCombinedFragmentsToBeDeleted(scenario, allXtextCombinedFragments);
        for (TimeLapse timeLapse : combinedFragmentsToBeDeleted) {
            XtextToDiagramCommands.removeCombinedFragmentFromScenario(scenario, timeLapse);
        }
    }

    private static List<TimeLapse> getCapellaCombinedFragmentsToBeDeleted(Scenario scenario, List<EObject> allXtextCombinedFragments) {
        List capellaCombinedFragments = scenario.getOwnedTimeLapses().stream().filter(timelapse -> timelapse instanceof CombinedFragment).collect(Collectors.toList());
        ArrayList<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment> processedXtextCombinedFragments = new ArrayList<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment>();
        ArrayList<TimeLapse> combinedFragmentsToBeDeleted = new ArrayList<TimeLapse>();
        for (TimeLapse timeLapse : capellaCombinedFragments) {
            if (XtextToDiagramCommands.foundCapellaCombinedFragmentInXText(timeLapse, allXtextCombinedFragments, processedXtextCombinedFragments)) continue;
            combinedFragmentsToBeDeleted.add(timeLapse);
        }
        return combinedFragmentsToBeDeleted;
    }

    private static boolean foundCapellaCombinedFragmentInXText(TimeLapse timeLapse, List<EObject> allXtextCombinedFragments, List<org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment> processedXtextCombinedFragments) {
        for (EObject xtextCombinedFragment : allXtextCombinedFragments) {
            if (processedXtextCombinedFragments.contains(xtextCombinedFragment) || !XtextToDiagramCommands.isSameCombinedFragment(xtextCombinedFragment, timeLapse)) continue;
            processedXtextCombinedFragments.add((org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)xtextCombinedFragment);
            return true;
        }
        return false;
    }

    private static boolean isSameCombinedFragment(EObject fragment, TimeLapse timeLapse) {
        EList capellaOperands;
        if (!(fragment instanceof org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)) {
            return false;
        }
        org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment xtextCombinedFragment = (org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)fragment;
        CombinedFragment correspondingCapellaFragment = (CombinedFragment)timeLapse;
        return correspondingCapellaFragment.getOperator().toString().equalsIgnoreCase(xtextCombinedFragment.getKeyword()) && XtextToDiagramCommands.haveSameTimelines(xtextCombinedFragment, correspondingCapellaFragment) && (capellaOperands = correspondingCapellaFragment.getReferencedOperands()).size() == xtextCombinedFragment.getOperands().size() + 1 && XtextToDiagramCommands.operandsHaveSameExpressions(xtextCombinedFragment, (List<InteractionOperand>)capellaOperands);
    }

    public static CombinedFragment getCombinedFragment(TimeLapse timeLapse) {
        List allocations = EObjectExt.getReferencers((EObject)timeLapse, (EReference)InteractionPackage.Literals.TIME_LAPSE__START);
        if (allocations.size() == 1 && allocations.get(0) instanceof CombinedFragment) {
            return (CombinedFragment)allocations.get(0);
        }
        allocations = EObjectExt.getReferencers((EObject)timeLapse, (EReference)InteractionPackage.Literals.TIME_LAPSE__FINISH);
        if (allocations.size() == 1 && allocations.get(0) instanceof CombinedFragment) {
            return (CombinedFragment)allocations.get(0);
        }
        return null;
    }

    private static List<TimeLapse> getCapellaStateFragmentsToBeDeleted(Scenario scenario, List<EObject> allXtextStateFragments) {
        List capellaStateFragments = scenario.getOwnedTimeLapses().stream().filter(timelapse -> timelapse instanceof org.polarsys.capella.core.data.interaction.StateFragment).collect(Collectors.toList());
        ArrayList<StateFragment> processedXtextStateFragments = new ArrayList<StateFragment>();
        ArrayList<TimeLapse> stateFragmentsToBeDeleted = new ArrayList<TimeLapse>();
        for (TimeLapse timeLapse : capellaStateFragments) {
            if (XtextToDiagramCommands.foundCapellaStateFragmentInXText(timeLapse, allXtextStateFragments, processedXtextStateFragments)) continue;
            stateFragmentsToBeDeleted.add(timeLapse);
        }
        return stateFragmentsToBeDeleted;
    }

    private static void removeMessageFromScenario(Scenario scenario, org.polarsys.capella.core.data.interaction.SequenceMessage sequenceMessage) {
        Execution execution = null;
        MessageEnd re = sequenceMessage.getReceivingEnd();
        for (TimeLapse tl : scenario.getOwnedTimeLapses()) {
            Execution exec;
            if (!(tl instanceof Execution) || (exec = (Execution)tl).getStart() == null || !exec.getStart().equals(re)) continue;
            execution = exec;
        }
        scenario.getOwnedTimeLapses().remove(execution);
        MessageEnd sendingEnd = sequenceMessage.getSendingEnd();
        MessageEnd receivingEnd = sequenceMessage.getReceivingEnd();
        InteractionFragment executionEnd = execution != null ? execution.getFinish() : null;
        scenario.getOwnedInteractionFragments().remove((Object)sendingEnd);
        scenario.getOwnedInteractionFragments().remove((Object)receivingEnd);
        scenario.getOwnedInteractionFragments().remove((Object)executionEnd);
        if (sendingEnd != null) {
            scenario.getOwnedEvents().remove((Object)sendingEnd.getEvent());
        }
        if (receivingEnd != null) {
            scenario.getOwnedEvents().remove((Object)receivingEnd.getEvent());
        }
        if (sendingEnd != null && receivingEnd != null && sequenceMessage.getKind() != MessageKind.REPLY && !ScenarioExt.hasReply((org.polarsys.capella.core.data.interaction.SequenceMessage)sequenceMessage)) {
            Event executionEvent = executionEnd instanceof ExecutionEnd ? (Event)ExecutionEndExt.getOperation((ExecutionEnd)((ExecutionEnd)executionEnd)) : null;
            scenario.getOwnedEvents().remove((Object)executionEvent);
        }
        scenario.getOwnedMessages().remove((Object)sequenceMessage);
    }

    private static void removeStateFragmentFromScenario(Scenario scenario, TimeLapse timeLapse) {
        org.polarsys.capella.core.data.interaction.StateFragment stateFragment = (org.polarsys.capella.core.data.interaction.StateFragment)timeLapse;
        scenario.getOwnedTimeLapses().remove((Object)timeLapse);
        scenario.getOwnedInteractionFragments().removeAll(Arrays.asList(stateFragment.getStart(), stateFragment.getFinish()));
    }

    private static void removeCombinedFragmentFromScenario(Scenario scenario, TimeLapse timeLapse) {
        CombinedFragment combinedFragment = (CombinedFragment)timeLapse;
        scenario.getOwnedTimeLapses().remove((Object)timeLapse);
        scenario.getOwnedInteractionFragments().removeAll(Arrays.asList(combinedFragment.getStart(), combinedFragment.getFinish()));
        scenario.getOwnedInteractionFragments().removeAll((Collection)combinedFragment.getReferencedOperands());
    }

    private static boolean foundCapellaMessageInXText(org.polarsys.capella.core.data.interaction.SequenceMessage capellaSequenceMessage, List<Message> allXtextSequenceMessages, List<Message> processedXtextSequenceMessages) {
        for (Message message : allXtextSequenceMessages) {
            if (processedXtextSequenceMessages.contains(message) || !XtextToDiagramCommands.isSameMessage((EObject)message, capellaSequenceMessage)) continue;
            processedXtextSequenceMessages.add(message);
            return true;
        }
        return false;
    }

    private static boolean foundCapellaStateFragmentInXText(TimeLapse timelapse, List<EObject> allXtextStateFragments, List<StateFragment> processedXtextStateFragments) {
        for (EObject stateFragment : allXtextStateFragments) {
            if (processedXtextStateFragments.contains(stateFragment) || !XtextToDiagramCommands.isSameStateFragment(stateFragment, timelapse)) continue;
            processedXtextStateFragments.add((StateFragment)stateFragment);
            return true;
        }
        return false;
    }

    private static List<Message> getAllXtextSequenceMessages(List<Element> elements) {
        ArrayList<Message> xtextSequenceMessages = new ArrayList<Message>();
        for (Element element : elements) {
            if (!(element instanceof SequenceMessageType) && !(element instanceof ArmTimerMessage) && !(element instanceof LostFoundMessage)) continue;
            xtextSequenceMessages.add((Message)element);
        }
        return xtextSequenceMessages;
    }

    private static void getAllXtextElements(List<Element> elements, List<Element> allXtextElements) {
        for (Element element : elements) {
            if (element instanceof org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment) {
                org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment combinedFragmentElement = (org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment)element;
                allXtextElements.add((Element)combinedFragmentElement);
                XtextToDiagramCommands.getAllXtextElements((List<Element>)combinedFragmentElement.getBlock().getBlockElements(), allXtextElements);
                for (EObject operand : combinedFragmentElement.getOperands()) {
                    XtextToDiagramCommands.getAllXtextElements((List<Element>)((Operand)operand).getBlock().getBlockElements(), allXtextElements);
                }
                continue;
            }
            allXtextElements.add(element);
        }
    }

    private static boolean isSameMessage(EObject xtextElement, org.polarsys.capella.core.data.interaction.SequenceMessage seqMessage) {
        if (!(xtextElement instanceof Message)) {
            return false;
        }
        MessageEnd sendingEnd = null;
        MessageEnd receivingEnd = null;
        String source = null;
        String target = null;
        String xtextMessageName = null;
        MessageKind xtextMessageKind = null;
        String capellaMessageName = seqMessage.getName();
        MessageKind capellaMessageKind = seqMessage.getKind();
        if (xtextElement instanceof SequenceMessageType) {
            SequenceMessageType message = (SequenceMessageType)xtextElement;
            sendingEnd = seqMessage.getSendingEnd();
            receivingEnd = seqMessage.getReceivingEnd();
            source = message.getSource();
            target = message.getTarget();
            xtextMessageName = message.getName();
            xtextMessageKind = XtextToDiagramCommands.getSequenceMessageKind((Message)message, false);
        } else if (xtextElement instanceof ArmTimerMessage) {
            ArmTimerMessage armTimerMessage = (ArmTimerMessage)xtextElement;
            sendingEnd = seqMessage.getSendingEnd();
            receivingEnd = seqMessage.getReceivingEnd();
            source = armTimerMessage.getParticipant();
            target = armTimerMessage.getParticipant();
            xtextMessageName = armTimerMessage.getName();
            xtextMessageKind = XtextToDiagramCommands.getSequenceMessageKind((Message)armTimerMessage, false);
        } else if (xtextElement instanceof LostMessage) {
            LostMessage lostMessage = (LostMessage)xtextElement;
            sendingEnd = seqMessage.getSendingEnd();
            receivingEnd = seqMessage.getReceivingEnd();
            source = lostMessage.getSource();
            xtextMessageName = lostMessage.getName();
            xtextMessageKind = XtextToDiagramCommands.getSequenceMessageKind((Message)lostMessage, false);
        } else if (xtextElement instanceof FoundMessage) {
            FoundMessage foundMessage = (FoundMessage)xtextElement;
            sendingEnd = seqMessage.getSendingEnd();
            receivingEnd = seqMessage.getReceivingEnd();
            target = foundMessage.getTarget();
            xtextMessageName = foundMessage.getName();
            xtextMessageKind = XtextToDiagramCommands.getSequenceMessageKind((Message)foundMessage, false);
        }
        return XtextToDiagramCommands.isSameMessage(source, target, sendingEnd, receivingEnd, xtextMessageName, capellaMessageName, xtextMessageKind, capellaMessageKind);
    }

    private static boolean isSameMessage(String source, String target, MessageEnd sendingEnd, MessageEnd receivingEnd, String messageName, String capellaMessageName, MessageKind xtextMessageKind, MessageKind capellaMessageKind) {
        if (sendingEnd == null && source != null || sendingEnd != null && source == null || receivingEnd == null && target != null || receivingEnd != null && target == null) {
            return false;
        }
        if (sendingEnd != null && receivingEnd == null && target == null) {
            return !sendingEnd.getCoveredInstanceRoles().isEmpty() && source.equals(((InstanceRole)sendingEnd.getCoveredInstanceRoles().get(0)).getName()) && messageName.equals(capellaMessageName) && xtextMessageKind.equals((Object)capellaMessageKind);
        }
        if (sendingEnd == null && receivingEnd != null && source == null) {
            return !receivingEnd.getCoveredInstanceRoles().isEmpty() && target.equals(((InstanceRole)receivingEnd.getCoveredInstanceRoles().get(0)).getName()) && messageName.equals(capellaMessageName) && xtextMessageKind.equals((Object)capellaMessageKind);
        }
        return sendingEnd != null && !sendingEnd.getCoveredInstanceRoles().isEmpty() && source.equals(((InstanceRole)sendingEnd.getCoveredInstanceRoles().get(0)).getName()) && !receivingEnd.getCoveredInstanceRoles().isEmpty() && target.equals(((InstanceRole)receivingEnd.getCoveredInstanceRoles().get(0)).getName()) && messageName.equals(capellaMessageName) && xtextMessageKind.equals((Object)capellaMessageKind);
    }

    private static boolean isSameStateFragment(EObject fragment, TimeLapse timelapse) {
        if (!(fragment instanceof StateFragment)) {
            return false;
        }
        StateFragment stateFragment = (StateFragment)fragment;
        org.polarsys.capella.core.data.interaction.StateFragment capellaStateFragment = (org.polarsys.capella.core.data.interaction.StateFragment)timelapse;
        return stateFragment.getTimeline().equals(((InstanceRole)capellaStateFragment.getStart().getCoveredInstanceRoles().get(0)).getName()) && stateFragment.getKeyword().equals(EmbeddedEditorInstanceHelper.getStateFragmentType((org.polarsys.capella.core.data.interaction.StateFragment)capellaStateFragment)) && stateFragment.getName().equals(EmbeddedEditorInstanceHelper.getStateFragmentName((org.polarsys.capella.core.data.interaction.StateFragment)capellaStateFragment));
    }

    private static org.polarsys.capella.core.data.interaction.SequenceMessage createCapellaSequenceMessage(Scenario scenario, InstanceRole source, InstanceRole target, Message seqMessage) {
        return XtextToDiagramCommands.createCapellaSequenceMessage(scenario, source, target, seqMessage, false);
    }

    private static org.polarsys.capella.core.data.interaction.SequenceMessage createCapellaSequenceMessage(Scenario scenario, InstanceRole source, InstanceRole target, Message seqMessage, boolean isReplyMessage) {
        org.polarsys.capella.core.data.interaction.SequenceMessage sequenceMessage = InteractionFactory.eINSTANCE.createSequenceMessage();
        sequenceMessage.setName(seqMessage.getName());
        sequenceMessage.setKind(XtextToDiagramCommands.getSequenceMessageKind(seqMessage, isReplyMessage));
        MessageEnd sendingEnd = null;
        if (source != null) {
            sendingEnd = InteractionFactory.eINSTANCE.createMessageEnd();
            sendingEnd.getCoveredInstanceRoles().add((Object)source);
            sequenceMessage.setSendingEnd(sendingEnd);
            scenario.getOwnedInteractionFragments().add((Object)sendingEnd);
        }
        MessageEnd receivingEnd = null;
        if (target != null) {
            receivingEnd = InteractionFactory.eINSTANCE.createMessageEnd();
            receivingEnd.getCoveredInstanceRoles().add((Object)target);
            sequenceMessage.setReceivingEnd(receivingEnd);
            scenario.getOwnedInteractionFragments().add((Object)receivingEnd);
        }
        if (!isReplyMessage && (seqMessage instanceof SequenceMessage || seqMessage instanceof ArmTimerMessage || seqMessage instanceof FoundMessage)) {
            ExecutionEnd executionEnd = InteractionFactory.eINSTANCE.createExecutionEnd();
            if (!XtextToDiagramCommands.hasReturn(seqMessage)) {
                scenario.getOwnedInteractionFragments().add((Object)executionEnd);
            }
            if (receivingEnd != null) {
                executionEnd.getCoveredInstanceRoles().add((Object)((InstanceRole)receivingEnd.getCoveredInstanceRoles().get(0)));
            }
            Execution execution = InteractionFactory.eINSTANCE.createExecution();
            execution.setFinish((InteractionFragment)executionEnd);
            if (receivingEnd != null) {
                execution.setStart((InteractionFragment)receivingEnd);
            }
            scenario.getOwnedTimeLapses().add((Object)execution);
            ExecutionEvent executionEvent = InteractionFactory.eINSTANCE.createExecutionEvent();
            executionEnd.setEvent((Event)executionEvent);
            scenario.getOwnedEvents().add((Object)executionEvent);
        }
        EventSentOperation eventSentOperation = InteractionFactory.eINSTANCE.createEventSentOperation();
        scenario.getOwnedEvents().add((Object)eventSentOperation);
        if (sendingEnd != null) {
            sendingEnd.setEvent((Event)eventSentOperation);
        }
        EventReceiptOperation eventRecvOperation = InteractionFactory.eINSTANCE.createEventReceiptOperation();
        scenario.getOwnedEvents().add((Object)eventRecvOperation);
        if (receivingEnd != null) {
            receivingEnd.setEvent((Event)eventRecvOperation);
        }
        String sourceName = source != null ? source.getName() : null;
        String targetName = target != null ? target.getName() : null;
        List<Object> exchanges = isReplyMessage ? EmbeddedEditorInstanceHelper.getExchangeMessages((String)targetName, (String)sourceName) : EmbeddedEditorInstanceHelper.getExchangeMessages((String)sourceName, (String)targetName);
        exchanges = EmbeddedEditorInstanceHelper.isInterfaceScenario() ? exchanges.stream().filter(ex -> ((ExchangeItemAllocation)ex).getAllocatedItem().getName().equals(seqMessage.getName())).collect(Collectors.toList()) : exchanges.stream().filter(ex -> ex.getName().equals(seqMessage.getName())).collect(Collectors.toList());
        if (!exchanges.isEmpty()) {
            eventRecvOperation.setOperation((AbstractEventOperation)exchanges.get(0));
            eventSentOperation.setOperation((AbstractEventOperation)exchanges.get(0));
        }
        return sequenceMessage;
    }

    private static MessageKind getSequenceMessageKind(Message seqMessage, boolean isReplyMessage) {
        if (seqMessage instanceof SequenceMessage) {
            return isReplyMessage ? MessageKind.REPLY : (((SequenceMessage)seqMessage).getReturn() != null ? MessageKind.SYNCHRONOUS_CALL : MessageKind.ASYNCHRONOUS_CALL);
        }
        if (seqMessage instanceof CreateMessage) {
            return MessageKind.CREATE;
        }
        if (seqMessage instanceof DeleteMessage) {
            return MessageKind.DELETE;
        }
        if (seqMessage instanceof ArmTimerMessage) {
            return MessageKind.TIMER;
        }
        if (seqMessage instanceof LostFoundMessage) {
            return MessageKind.ASYNCHRONOUS_CALL;
        }
        return MessageKind.UNSET;
    }

    private static void doDeactivationSequenceMessageForReorder(List<InteractionFragment> fragments, InstanceRole instanceRole, List<InteractionFragment> executionEndsToProcess, List<org.polarsys.capella.core.data.interaction.SequenceMessage> sequenceMessages) {
        InteractionFragment executionEnd = XtextToDiagramCommands.getLatestExecutionEndOnTimeline(instanceRole, executionEndsToProcess);
        org.polarsys.capella.core.data.interaction.SequenceMessage sequenceMessage = null;
        org.polarsys.capella.core.data.interaction.SequenceMessage oppositeSequenceMessage = null;
        if (executionEnd != null) {
            if (executionEnd instanceof ExecutionEnd) {
                sequenceMessage = ExecutionEndExt.getMessage((ExecutionEnd)((ExecutionEnd)executionEnd));
            } else {
                sequenceMessage = ((MessageEnd)executionEnd).getMessage();
                oppositeSequenceMessage = XtextToDiagramCommands.getOppositeSequenceMessage(sequenceMessage, fragments);
            }
            if (oppositeSequenceMessage != null) {
                fragments.add((InteractionFragment)sequenceMessage.getSendingEnd());
                fragments.add((InteractionFragment)sequenceMessage.getReceivingEnd());
                sequenceMessages.add(sequenceMessage);
            } else {
                fragments.add(executionEnd);
            }
        }
        executionEndsToProcess.remove(executionEnd);
    }

    private static InteractionFragment getLatestExecutionEndOnTimeline(InstanceRole instanceRole, List<InteractionFragment> executionEndsToProcess) {
        return executionEndsToProcess.stream().filter(e -> ((InstanceRole)e.getCoveredInstanceRoles().get(0)).getName().equals(instanceRole.getName())).reduce((first, second) -> second).orElse(null);
    }

    private static void createCapellaCombinedFragmentBlock(Scenario scenario, org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment xtextCombinedFragment, InteractionFragment lastInteractionFragment, List<org.polarsys.capella.core.data.interaction.SequenceMessage> processedCapellaMessages, ArrayList<CombinedFragment> processedCapellaCombinedFragments, ArrayList<StateFragment> previousStateFragments, ArrayList<Reference> previousReferences) {
        FragmentEnd start = InteractionFactory.eINSTANCE.createFragmentEnd();
        FragmentEnd finish = InteractionFactory.eINSTANCE.createFragmentEnd();
        xtextCombinedFragment.getTimelines().forEach(timeline -> {
            InstanceRole instanceRole = EmbeddedEditorInstanceHelper.getInstanceRole((String)timeline);
            start.getCoveredInstanceRoles().add((Object)instanceRole);
            finish.getCoveredInstanceRoles().add((Object)instanceRole);
        });
        start.setName("start");
        finish.setName("end");
        scenario.getOwnedInteractionFragments().add((Object)start);
        scenario.getOwnedInteractionFragments().add((Object)finish);
        if (lastInteractionFragment != null) {
            ScenarioExt.moveEndOnScenario((InteractionFragment)start, (InteractionFragment)lastInteractionFragment);
        } else {
            ScenarioExt.moveEndOnBeginingOfScenario((InteractionFragment)start);
        }
        CombinedFragment combinedFragment = XtextToDiagramCommands.createCombinedFragment((InteractionFragment)start, (InteractionFragment)finish, InteractionOperatorKind.getByName((String)xtextCombinedFragment.getKeyword().toUpperCase()));
        scenario.getOwnedTimeLapses().add((Object)combinedFragment);
        processedCapellaCombinedFragments.add(combinedFragment);
        Block firstBlock = xtextCombinedFragment.getBlock();
        if (firstBlock != null) {
            InteractionOperand operand = XtextToDiagramCommands.createInteractionOperand((EList<InstanceRole>)start.getCoveredInstanceRoles(), xtextCombinedFragment.getExpression());
            combinedFragment.getReferencedOperands().add((Object)operand);
            scenario.getOwnedInteractionFragments().add((Object)operand);
            ScenarioExt.moveEndOnScenario((InteractionFragment)operand, (InteractionFragment)start);
            XtextToDiagramCommands.editElements(scenario, (EList<Element>)firstBlock.getBlockElements(), processedCapellaMessages, processedCapellaCombinedFragments, previousStateFragments, previousReferences);
            InteractionOperand prevEnd = operand;
            for (Operand operandBlock : xtextCombinedFragment.getOperands()) {
                InteractionOperand operand2 = XtextToDiagramCommands.createInteractionOperand((EList<InstanceRole>)start.getCoveredInstanceRoles(), operandBlock.getExpression());
                combinedFragment.getReferencedOperands().add((Object)operand2);
                scenario.getOwnedInteractionFragments().add((Object)operand2);
                ScenarioExt.moveEndOnScenario((InteractionFragment)operand2, (InteractionFragment)prevEnd);
                prevEnd = operand2;
                XtextToDiagramCommands.editElements(scenario, (EList<Element>)operandBlock.getBlock().getBlockElements(), processedCapellaMessages, processedCapellaCombinedFragments, previousStateFragments, previousReferences);
            }
        }
    }

    private static InteractionOperand createInteractionOperand(EList<InstanceRole> coveredInstanceRoles, String condition) {
        InteractionOperand operand = InteractionFactory.eINSTANCE.createInteractionOperand();
        operand.setName("operand");
        operand.getCoveredInstanceRoles().addAll(coveredInstanceRoles);
        if (condition != null) {
            Constraint constraint = CapellacoreFactory.eINSTANCE.createConstraint();
            OpaqueExpression expression = DatavalueFactory.eINSTANCE.createOpaqueExpression();
            constraint.setOwnedSpecification((ValueSpecification)expression);
            operand.getOwnedConstraints().add((Object)constraint);
            CreationHelper.performContributionCommands((EObject)constraint, (EObject)operand);
            expression.getLanguages().add((Object)"capella:linkedText");
            expression.getBodies().add((Object)condition);
            operand.setGuard(constraint);
        }
        return operand;
    }

    private static CombinedFragment createCombinedFragment(InteractionFragment start, InteractionFragment finish, InteractionOperatorKind kind) {
        CombinedFragment combinedFragment = InteractionFactory.eINSTANCE.createCombinedFragment();
        combinedFragment.setOperator(kind);
        combinedFragment.setStart(start);
        combinedFragment.setFinish(finish);
        combinedFragment.setName("combined fragment");
        return combinedFragment;
    }

    private static void editReference(Scenario scenario, Reference xtextElement, List<Reference> previousEditorReference) {
        ArrayList<InstanceRole> instanceRoles = new ArrayList<InstanceRole>();
        for (String timeline : xtextElement.getTimelines()) {
            instanceRoles.add(EmbeddedEditorInstanceHelper.getInstanceRole((String)timeline));
        }
        List simillarReferences = previousEditorReference.stream().filter(x -> x.getName().equals(xtextElement.getName()) && XtextToDiagramCommands.haveSameTimelines(x, xtextElement)).collect(Collectors.toList());
        List capellaReferences = scenario.getOwnedTimeLapses().stream().filter(x -> x instanceof InteractionUse && XtextToDiagramCommands.isSameReference((EObject)xtextElement, x)).collect(Collectors.toList());
        if (capellaReferences.isEmpty() || capellaReferences.size() < simillarReferences.size()) {
            XtextToDiagramCommands.createCapellaReference(scenario, instanceRoles, xtextElement);
        }
    }

    private static boolean haveSameTimelines(Reference ref1, Reference ref2) {
        return ref1.getTimelines().stream().collect(Collectors.toSet()).equals(ref2.getTimelines().stream().collect(Collectors.toSet()));
    }

    private static void createCapellaReference(Scenario scenario, List<InstanceRole> instanceRoles, Reference xtextElement) {
        FragmentEnd start = InteractionFactory.eINSTANCE.createFragmentEnd();
        FragmentEnd finish = InteractionFactory.eINSTANCE.createFragmentEnd();
        start.getCoveredInstanceRoles().addAll(instanceRoles);
        finish.getCoveredInstanceRoles().addAll(instanceRoles);
        start.setName("start");
        finish.setName("end");
        scenario.getOwnedInteractionFragments().add((Object)start);
        scenario.getOwnedInteractionFragments().add((Object)finish);
        InteractionUse reference = XtextToDiagramCommands.createInteractionUse(scenario, start, finish, xtextElement);
        scenario.getOwnedTimeLapses().add((Object)reference);
    }

    private static InteractionUse createInteractionUse(Scenario scenario, FragmentEnd start, FragmentEnd finish, Reference xtextElement) {
        InteractionUse interactionUse = InteractionFactory.eINSTANCE.createInteractionUse("interactionUse");
        interactionUse.setStart((InteractionFragment)start);
        interactionUse.setFinish((InteractionFragment)finish);
        Scenario referencedScenario = EmbeddedEditorInstanceHelper.getScenarioWithGivenName((String)xtextElement.getName());
        if (referencedScenario != null) {
            interactionUse.setReferencedScenario(referencedScenario);
        }
        return interactionUse;
    }

    private static InteractionUse getCorrespondingCapellaReference(Scenario scenario, Reference reference, List<InteractionFragment> interactionFragments) {
        List filteredTimeLapses = scenario.getOwnedTimeLapses().stream().filter(x -> x instanceof InteractionUse && XtextToDiagramCommands.isSameReference((EObject)reference, x) && !interactionFragments.contains(((InteractionUse)x).getStart())).collect(Collectors.toList());
        if (!filteredTimeLapses.isEmpty()) {
            return (InteractionUse)filteredTimeLapses.get(0);
        }
        return null;
    }

    private static void cleanUpReferences(Scenario scenario, List<Element> xTextElements) {
        List<EObject> allXtextReferences = xTextElements.stream().filter(element -> element instanceof Reference).collect(Collectors.toList());
        List<TimeLapse> referencesToBeDeleted = XtextToDiagramCommands.getCapellaReferencesToBeDeleted(scenario, allXtextReferences);
        for (TimeLapse timeLapse : referencesToBeDeleted) {
            XtextToDiagramCommands.removeReferenceFromScenario(scenario, timeLapse);
        }
    }

    private static List<TimeLapse> getCapellaReferencesToBeDeleted(Scenario scenario, List<EObject> allXtextReferences) {
        List<TimeLapse> capellaReferences = scenario.getOwnedTimeLapses().stream().filter(timelapse -> timelapse instanceof InteractionUse).collect(Collectors.toList());
        ArrayList<Reference> processedXtextReferences = new ArrayList<Reference>();
        ArrayList<TimeLapse> referencesToBeDeleted = new ArrayList<TimeLapse>();
        if (allXtextReferences.isEmpty()) {
            return capellaReferences;
        }
        for (TimeLapse timeLapse : capellaReferences) {
            if (XtextToDiagramCommands.foundCapellaReferenceInXText(timeLapse, allXtextReferences, processedXtextReferences)) continue;
            referencesToBeDeleted.add(timeLapse);
        }
        return referencesToBeDeleted;
    }

    private static void removeReferenceFromScenario(Scenario scenario, TimeLapse timeLapse) {
        InteractionUse reference = (InteractionUse)timeLapse;
        scenario.getOwnedTimeLapses().remove((Object)timeLapse);
        scenario.getOwnedInteractionFragments().removeAll(Arrays.asList(reference.getStart(), reference.getFinish()));
    }

    private static boolean foundCapellaReferenceInXText(TimeLapse timelapse, List<EObject> allXtextReferences, List<Reference> processedXtextReferences) {
        for (EObject reference : allXtextReferences) {
            if (processedXtextReferences.contains(reference) || !XtextToDiagramCommands.isSameReference(reference, timelapse)) continue;
            processedXtextReferences.add((Reference)reference);
            return true;
        }
        return false;
    }

    private static boolean isSameReference(EObject reference, TimeLapse timelapse) {
        if (!(reference instanceof Reference)) {
            return false;
        }
        Reference xtextReference = (Reference)reference;
        InteractionUse capellaReference = (InteractionUse)timelapse;
        if (!xtextReference.getName().equals(capellaReference.getReferencedScenario().getName())) {
            return false;
        }
        Set capellaTimelines = capellaReference.getStart().getCoveredInstanceRoles().stream().map(x -> x.getName()).collect(Collectors.toSet());
        return capellaTimelines.equals(xtextReference.getTimelines().stream().collect(Collectors.toSet()));
    }

    public static org.polarsys.capella.core.data.interaction.SequenceMessage getOppositeSequenceMessage(org.polarsys.capella.core.data.interaction.SequenceMessage sequenceMessage, List<InteractionFragment> fragments) {
        boolean flag = false;
        List<org.polarsys.capella.core.data.interaction.SequenceMessage> setPortionMessage = new ArrayList();
        ArrayDeque<org.polarsys.capella.core.data.interaction.SequenceMessage> messagesStack = new ArrayDeque<org.polarsys.capella.core.data.interaction.SequenceMessage>();
        if (!(sequenceMessage == null || sequenceMessage.getKind().equals((Object)MessageKind.CREATE) || sequenceMessage.getKind().equals((Object)MessageKind.DELETE) || sequenceMessage.getKind().equals((Object)MessageKind.ASYNCHRONOUS_CALL))) {
            ArrayList<MessageEnd> ownedMsgEnd = new ArrayList<MessageEnd>();
            for (InteractionFragment abs : fragments) {
                if (!(abs instanceof MessageEnd)) continue;
                ownedMsgEnd.add((MessageEnd)abs);
            }
            if (ownedMsgEnd != null) {
                org.polarsys.capella.core.data.interaction.SequenceMessage msg;
                if (sequenceMessage.getKind().equals((Object)MessageKind.REPLY)) {
                    flag = false;
                    Iterator it = ownedMsgEnd.iterator();
                    while (it.hasNext() && !flag) {
                        MessageEnd msgEnd = (MessageEnd)it.next();
                        if (msgEnd == null || (msg = msgEnd.getMessage()) == null) continue;
                        if (!msg.equals(sequenceMessage)) {
                            setPortionMessage.add(msg);
                            continue;
                        }
                        flag = true;
                    }
                    setPortionMessage = SequenceMessageExt.reverse(setPortionMessage);
                } else {
                    flag = false;
                    for (MessageEnd msgEnd : ownedMsgEnd) {
                        if (msgEnd == null || (msg = msgEnd.getMessage()) == null) continue;
                        if (flag) {
                            setPortionMessage.add(msg);
                            continue;
                        }
                        if (!msg.equals(sequenceMessage)) continue;
                        flag = true;
                    }
                }
                for (org.polarsys.capella.core.data.interaction.SequenceMessage msg2 : setPortionMessage) {
                    if (msg2.getKind().equals((Object)MessageKind.CREATE) || msg2.getKind().equals((Object)MessageKind.DELETE) || msg2.getKind().equals((Object)MessageKind.ASYNCHRONOUS_CALL)) continue;
                    if (sequenceMessage.getKind().equals((Object)MessageKind.REPLY)) {
                        if (msg2.getKind().equals((Object)MessageKind.REPLY)) {
                            messagesStack.push(msg2);
                            continue;
                        }
                        if (messagesStack.isEmpty()) {
                            return msg2;
                        }
                        messagesStack.pop();
                        continue;
                    }
                    if (msg2.getKind().equals((Object)MessageKind.REPLY)) {
                        if (messagesStack.isEmpty()) {
                            return msg2;
                        }
                        messagesStack.pop();
                        continue;
                    }
                    messagesStack.push(msg2);
                }
            }
        }
        return null;
    }

    public static boolean isSameExpression(String operandExpression, String textExpression) {
        if (operandExpression == null && textExpression == null) {
            return true;
        }
        if (operandExpression != null && textExpression != null) {
            return operandExpression.equals(textExpression);
        }
        return false;
    }
}

