/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.task;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.emf.common.util.URI;

public class UnzipTask
implements ITaskProduction {
    private static final String TEMP_ZIP = "temp.zip";

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        URI uri = (URI)productionContext.getInputValue((Object)"zipFileURI", URI.class);
        String projectName = (String)productionContext.getInputValue((Object)"projectName", String.class);
        String outputFolder = (String)productionContext.getInputValue((Object)"outputFolder", String.class);
        try {
            URL url = new URL(uri.toString());
            InputStream input = url.openConnection().getInputStream();
            IPath outputFolderPath = new Path(projectName).append(outputFolder);
            IContainer folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputFolderPath).getParent();
            Path tempZipPath = new Path(TEMP_ZIP);
            IFile file = folder.getFile((IPath)tempZipPath);
            file.create(input, true, monitor);
            input.close();
            File javaFile = new File(file.getLocation().toOSString());
            ZipFile zipFile = new ZipFile(javaFile);
            UnzipTask.unzipZipResource(zipFile, folder.getLocation().toString());
            file.delete(true, monitor);
            folder.refreshLocal(2, monitor);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    private static void unzipZipResource(ZipFile zipFile, String destination) {
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String fileName = String.valueOf(destination) + "/" + entry.getName();
                if (entry.isDirectory()) {
                    new File(fileName).mkdirs();
                    continue;
                }
                String name = entry.getName();
                int index = name.lastIndexOf(47);
                if (index != -1) {
                    String dirPath = name.substring(0, index);
                    UnzipTask.makeDir(String.valueOf(destination) + "/" + dirPath);
                }
                File output = new File(fileName);
                UnzipTask.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(output)));
            }
            zipFile.close();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    private static boolean makeDir(String fileFullPath) {
        File dir = new File(fileFullPath);
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    private static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int read = in.read();
        while (read != -1) {
            out.write(read);
            read = in.read();
        }
        in.close();
        out.close();
    }
}

