/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.util;

import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.util.EObjectLabelProviderHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.GenDocExtendedImageRegistry;

public class LabelProviderHelper {
    private static final String PNG = "png";
    private static final String GIF = "gif";
    private static final String ICON_FOLDER_NAME = "icon";
    private static final NullProgressMonitor MONITOR = new NullProgressMonitor();

    private LabelProviderHelper() {
    }

    public static void initImageRegistry() {
        GenDocExtendedImageRegistry.getInstance();
    }

    public static void disposeImageRegistry() {
        GenDocExtendedImageRegistry.getInstance().dispose();
    }

    public static String getText(EObject eObject) {
        Object eObjectLabelProvider;
        String result = EObjectLabelProviderHelper.getText(eObject);
        if (result.equals("") && (eObjectLabelProvider = LabelProviderHelper.getIItemLabelProvider(eObject)) instanceof IItemLabelProvider) {
            result = ((IItemLabelProvider)eObjectLabelProvider).getText((Object)eObject);
        }
        return result;
    }

    private static Object getIItemLabelProvider(EObject eObject) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        return adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
    }

    public static Object getImage(EObject eObject) {
        Object eObjectLabelProvider = LabelProviderHelper.getIItemLabelProvider(eObject);
        if (eObjectLabelProvider instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)eObjectLabelProvider).getImage((Object)eObject);
        }
        return null;
    }

    public static String getImageFileName(EObject eObject, String projectName, String folderName) {
        String withoutFileExtension;
        IFile iconFileTemp;
        Object imageObject = LabelProviderHelper.getImage(eObject);
        Image image = LabelProviderHelper.getImageFromObject(imageObject);
        String simpleFileName = LabelProviderHelper.getImageName(imageObject);
        IFolder iconFolder = LabelProviderHelper.getIconFolder(projectName, folderName);
        IFile iconFile = iconFolder.getFile(simpleFileName);
        if (!iconFile.exists() && (iconFileTemp = LabelProviderHelper.createNewIconFile(image, withoutFileExtension = iconFile.getLocation().toString().replace(iconFile.getLocation().getFileExtension(), ""))) != null) {
            iconFile = iconFileTemp;
        }
        return iconFile.getName();
    }

    private static String getImageName(Object imageObject) {
        Object mainImageObject;
        String simpleFileName = "";
        if (imageObject instanceof URL) {
            simpleFileName = URI.createURI((String)((URL)imageObject).toString()).lastSegment();
        } else if (imageObject instanceof ComposedImage && (mainImageObject = ((ComposedImage)imageObject).getImages().get(0)) != null) {
            simpleFileName = "controlled_" + LabelProviderHelper.getImageName(mainImageObject);
        }
        return simpleFileName;
    }

    private static Image getImageFromObject(Object object) {
        try {
            return GenDocExtendedImageRegistry.getInstance().getImage(object);
        }
        catch (Exception e) {
            Activator.logWarning(e.getMessage(), e);
            return null;
        }
    }

    private static IFile createNewIconFile(Image iconImage, String fileName) {
        if (iconImage != null) {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{iconImage.getImageData()};
            try {
                if (iconImage.getImageData().depth > 8) {
                    fileName = String.valueOf(fileName) + PNG;
                    loader.save(fileName, 5);
                } else {
                    fileName = String.valueOf(fileName) + GIF;
                    loader.save(fileName, 2);
                }
            }
            catch (Exception e) {
                Activator.logWarning(e.getMessage(), e);
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        }
        return null;
    }

    private static IFolder getIconFolder(String projectName, String folderName) {
        IPath path = new Path(projectName).append(folderName);
        IContainer parent = ResourcesPlugin.getWorkspace().getRoot().getFolder(path).getParent();
        IPath iconPath = parent.getFullPath().append(ICON_FOLDER_NAME);
        IFolder iconFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iconPath);
        if (iconFolder == null || !iconFolder.exists()) {
            try {
                FileHelper.createContainers((IProgressMonitor)MONITOR, (IResource)iconFolder);
                iconFolder.create(true, true, (IProgressMonitor)MONITOR);
            }
            catch (CoreException e) {
                Activator.logWarning(e.getMessage(), e);
            }
        }
        return iconFolder;
    }
}

