/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.model.edit.EGFModelEditPlugin;
import org.eclipse.egf.model.edit.l10n.EGFModelEditMessages;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternRemovePatternMethodCommand
extends RemoveCommand {
    protected List<PatternMethod> _methods;
    protected Resource _resource;

    public PatternRemovePatternMethodCommand(EditingDomain domain, EObject owner, Collection<?> collection) {
        super(domain, owner, (EStructuralFeature)PatternPackage.Literals.PATTERN__METHODS, collection);
    }

    protected boolean prepare() {
        boolean result = super.prepare();
        if (!result) {
            return false;
        }
        if (!(this.owner instanceof Pattern)) {
            return false;
        }
        if (this.feature != PatternPackage.Literals.PATTERN__METHODS) {
            return false;
        }
        Pattern pattern = (Pattern)this.owner;
        if (pattern.eResource() == null || !(pattern.eResource() instanceof IPlatformFcoreProvider)) {
            return false;
        }
        this._methods = new UniqueEList();
        for (Object object : this.collection) {
            if (!(object instanceof PatternMethod)) continue;
            this._methods.add((PatternMethod)object);
        }
        this._resource = pattern.eResource();
        return true;
    }

    public void doUndo() {
        PatternRemovePatternMethodCommand.performRestorePatternMethods(this._resource, this._methods);
        super.doUndo();
    }

    public static void performDeletePatternMethods(final Resource resource, final List<PatternMethod> methods) {
        if (resource == null || methods == null || methods.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(EGFModelEditMessages.RemovePatternMethodCommand_execute){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    TemplateModelFileHelper.removeTemplates((IProgressMonitor)monitor, (List)methods);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Throwable t) {
                    if (t instanceof CoreException) {
                        IStatus iStatus = ((CoreException)t).getStatus();
                        return iStatus;
                    }
                    IStatus iStatus = EGFModelEditPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFModelEditMessages.PatternRemovePatternMethodCommand_execute_exception, (Object)resource.getURI()), t);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setRule((ISchedulingRule)EMFHelper.getProject((Resource)resource));
        job.schedule();
    }

    public static void performRestorePatternMethods(final Resource resource, final List<PatternMethod> methods) {
        if (resource == null || methods == null || methods.isEmpty() || !(resource instanceof IPlatformFcoreProvider)) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(EGFModelEditMessages.RestorePatternMethodCommand_execute){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    TemplateModelFileHelper.restoreTemplates((IProgressMonitor)monitor, (IPlatformFcore)((IPlatformFcoreProvider)resource).getIPlatformFcore(), (List)methods);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Throwable t) {
                    if (t instanceof CoreException) {
                        IStatus iStatus = ((CoreException)t).getStatus();
                        return iStatus;
                    }
                    IStatus iStatus = EGFModelEditPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFModelEditMessages.PatternRestorePatternMethodCommand_execute_exception, (Object)resource.getURI()), t);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setRule((ISchedulingRule)EMFHelper.getProject((Resource)resource));
        job.schedule();
    }
}

