/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.jdt;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.handlers.AbstractArtifactHandler;
import org.eclipse.capra.core.handlers.AnnotationException;
import org.eclipse.capra.core.handlers.IAnnotateArtifact;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.handler.jdt.JDTAnnotate;
import org.eclipse.capra.handler.jdt.preferences.JDTPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class JavaElementHandler
extends AbstractArtifactHandler<IJavaElement>
implements IAnnotateArtifact {
    public EObject createWrapper(IJavaElement element, EObject artifactModel) {
        IType type = (IType)element.getParent().getAncestor(7);
        String fragment = type == null ? (element.getElementType() == 7 ? ((IType)element).getFullyQualifiedName() : element.getElementName()) : String.valueOf(type.getFullyQualifiedName().replace("\\$", "/")) + "/" + element.getElementName();
        URIBuilder uriBuilder = new URIBuilder().setScheme("platform").setPath("/resource" + element.getPath()).setFragment(fragment);
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        String displayName = String.valueOf(type == null ? "" : String.valueOf(type.getElementName()) + ".") + element.getElementName();
        return adapter.createArtifact(artifactModel, ((Object)((Object)this)).getClass().getName(), uriBuilder.toString(), element.getHandleIdentifier(), displayName);
    }

    public IJavaElement resolveWrapper(EObject wrapper) {
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        return JavaCore.create((String)adapter.getArtifactInternalResolver(wrapper));
    }

    public boolean doesArtifactExist(EObject wrapper) {
        IJavaElement javaElement = this.resolveWrapper(wrapper);
        return javaElement != null && javaElement.exists();
    }

    public String getDisplayName(IJavaElement element) {
        return element.getElementName();
    }

    public void annotateArtifact(EObject wrapper, String annotation) throws AnnotationException {
        IEclipsePreferences preferences = JDTPreferences.getPreferences();
        if (preferences.getBoolean("ANNOTATE_JDT", false)) {
            IJavaElement handle = this.resolveWrapper(wrapper);
            JDTAnnotate.annotateArtifact(handle, annotation);
        }
    }

    public String generateMarkerMessage(IResourceDelta delta, String wrapperUri) {
        String message = "";
        IJavaElement linkedElement = JavaCore.create((String)wrapperUri);
        IJavaElement changedResource = JavaCore.create((IResource)delta.getResource());
        if (linkedElement == null || changedResource == null) {
            return null;
        }
        if (changedResource.getHandleIdentifier().equals(wrapperUri)) {
            message = String.valueOf(delta.getResource().getFullPath().toString()) + " has been edited. Please check if associated trace links are still valid.";
        } else {
            IJavaElement[] jElements = ((ICompilationUnit)changedResource).findElements(linkedElement);
            if (jElements == null) {
                message = String.valueOf(linkedElement.getHandleIdentifier()) + " has either been deleted or had its signature changed. Please check if associated trace links are still valid.";
            } else {
                IJavaElement jElement = jElements[0];
                try {
                    IFileState fs = ((IFile)delta.getResource()).getHistory((IProgressMonitor)new NullProgressMonitor())[0];
                    String previousState = new BufferedReader(new InputStreamReader(fs.getContents())).lines().collect(Collectors.joining("\n"));
                    if (linkedElement instanceof ISourceReference && !previousState.contains(((ISourceReference)jElement).getSource())) {
                        message = String.valueOf(linkedElement.getHandleIdentifier()) + " has been edited. Please check if associated trace links are still valid.";
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return message;
    }

    public List<Connection> getInternalLinks(EObject investigatedElement, List<String> selectedRelationshipTypes, boolean reverseDirection) {
        return Collections.emptyList();
    }

    public boolean isThereAnInternalTraceBetween(EObject first, EObject second) {
        return false;
    }
}

