/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class SelectionView
extends ViewPart {
    public static final String ID = "org.eclipse.capra.generic.views.SelectionView";
    private static final String TRANSFER_EXTENSION_POINT_ID = "org.eclipse.capra.ui.transfers";
    private static final Transfer[] DEFAULT_TRANSFERS = new Transfer[]{ResourceTransfer.getInstance(), EditorInputTransfer.getInstance(), FileTransfer.getInstance(), RTFTransfer.getInstance(), TextTransfer.getInstance(), URLTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), LocalTransfer.getInstance()};
    public TableViewer viewer;
    private Set<Object> selection = new LinkedHashSet<Object>();

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setComparator((ViewerComparator)new NoChangeComparator());
        this.viewer.setInput((Object)this.getViewSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu();
        int ops = 3;
        ArrayList<Transfer> transfers = new ArrayList<Transfer>(Arrays.asList(DEFAULT_TRANSFERS));
        transfers.addAll(ExtensionPointHelper.getExtensions((String)TRANSFER_EXTENSION_POINT_ID, (String)"class").stream().map(Transfer.class::cast).collect(Collectors.toList()));
        this.viewer.addDropSupport(ops, transfers.toArray(DEFAULT_TRANSFERS), (DropTargetListener)new SelectionDropAdapter(this.viewer));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dropToSelection(Object data) {
        if (data instanceof TreeSelection) {
            TreeSelection tree = (TreeSelection)data;
            if (tree.toList().stream().allMatch(this::validateSelection)) {
                this.selection.addAll(tree.toList());
            }
        } else if (data instanceof Collection) {
            Collection arrayselection = (Collection)data;
            if (arrayselection.stream().allMatch(this::validateSelection)) {
                this.selection.addAll(arrayselection);
            }
        } else if (data instanceof IStructuredSelection) {
            IStructuredSelection iselection = (IStructuredSelection)data;
            if (iselection.toList().stream().allMatch(this::validateSelection)) {
                this.selection.addAll(iselection.toList());
            }
        } else if (this.validateSelection(data)) {
            this.selection.add(data);
        }
        this.viewer.refresh();
    }

    private boolean validateSelection(Object target) {
        Collection artifactHandlers = ExtensionPointHelper.getArtifactHandlers();
        List availableHandlers = artifactHandlers.stream().filter(handler -> handler.canHandleArtifact(target)).collect(Collectors.toList());
        Optional priorityHandler = ExtensionPointHelper.getPriorityHandler();
        if (availableHandlers.size() == 0) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"No handler for selected item", (String)("There is no handler for " + target + " so it will be ignored."));
        } else if (availableHandlers.size() > 1 && !priorityHandler.isPresent()) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Multiple handlers for selected item", (String)("There are multiple handlers for " + target + " so it will be ignored."));
        } else {
            if (availableHandlers.size() > 1 && priorityHandler.isPresent()) {
                return true;
            }
            return true;
        }
        return false;
    }

    public List<Object> getSelection() {
        return new ArrayList<Object>(this.selection);
    }

    public void clearSelection() {
        this.selection.clear();
        this.viewer.refresh();
    }

    public static SelectionView getOpenedView() {
        try {
            return (SelectionView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeFromSelection(List<Object> currentselection) {
        this.selection.removeAll(currentselection);
        this.viewer.refresh();
    }

    class NoChangeComparator
    extends ViewerComparator {
        NoChangeComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return 0;
        }
    }

    class SelectionDropAdapter
    extends ViewerDropAdapter {
        TableViewer view;

        public SelectionDropAdapter(TableViewer view) {
            super((Viewer)SelectionView.this.viewer);
            this.view = view;
        }

        public boolean performDrop(Object data) {
            SelectionView.this.dropToSelection(data);
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return true;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return SelectionView.this.selection.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object element) {
            TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
            EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)new ResourceSetImpl());
            ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
            IArtifactHandler handler = (IArtifactHandler)artifactHelper.getHandler(element).get();
            return handler.withCastedHandler(element, (h, o) -> h.getDisplayName(o)).orElseGet(element::toString);
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

