/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TransitivityDepthHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        String initialValue = TransitivityDepthHandler.getTransitivityDepth();
        InputDialog depthInput = new InputDialog(window.getShell(), "Transitivity depth", "Input the desired depth limit for transitivity. Enter 0 if no limit is desired.", initialValue, null);
        if (depthInput.open() == 0) {
            String depth = depthInput.getValue();
            TransitivityDepthHandler.setTransitivityDepth(depth);
        }
        return null;
    }

    public static String getTransitivityDepth() {
        Preferences transitivity = TransitivityDepthHandler.getPreference();
        return transitivity.get("option", "0");
    }

    private static Preferences getPreference() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.plantuml.transitivityDepth");
        Preferences transitivity = preferences.node("transitivityDepth");
        return transitivity;
    }

    public static void setTransitivityDepth(String depth) {
        Preferences transitivity = TransitivityDepthHandler.getPreference();
        transitivity.put("option", depth);
        try {
            transitivity.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

