/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TargetPlatformBundleActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cbi.targetplatform";
    public static final String TARGET_PLATFORM_LANGUAGE_NAME = "org.eclipse.cbi.TargetPlatform";
    private static TargetPlatformBundleActivator INSTANCE;
    private BundleContext context;
    private ServiceReference<IProvisioningAgentProvider> agentProviderRef;
    private IProvisioningAgent agent;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        this.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        IProvisioningAgent oldAgent = this.agent;
        this.agent = null;
        if (oldAgent != null) {
            oldAgent.stop();
        }
        if (this.agentProviderRef != null) {
            context.ungetService(this.agentProviderRef);
        }
        this.agentProviderRef = null;
        this.context = null;
        INSTANCE = null;
        super.stop(context);
    }

    public static TargetPlatformBundleActivator getInstance() {
        return INSTANCE;
    }

    public IProvisioningAgent getProvisioningAgent() {
        if (this.agent == null) {
            this.agentProviderRef = this.context.getServiceReference(IProvisioningAgentProvider.class);
            if (this.agentProviderRef != null) {
                IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)this.context.getService(this.agentProviderRef);
                if (agentProvider != null) {
                    try {
                        this.agent = agentProvider.createAgent(this.getStateLocation().toFile().toURI());
                    }
                    catch (ProvisionException e) {
                        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
                    }
                    catch (IllegalStateException e) {
                        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
                    }
                }
            } else {
                this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Cannot find a service reference to " + IProvisioningAgentProvider.class.getName()));
            }
        }
        return this.agent;
    }
}

