/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.cft.server.ui.internal.console.ApplicationLogStreamProvider;
import org.eclipse.cft.server.ui.internal.console.ConsoleStream;
import org.eclipse.cft.server.ui.internal.console.ConsoleStreamProvider;
import org.eclipse.cft.server.ui.internal.console.StdStreamProvider;
import org.eclipse.cft.server.ui.internal.console.TraceStreamProvider;

public class ConsoleStreamRegistry {
    private static ConsoleStreamRegistry current;
    private List<ConsoleStreamProvider> providers;

    public static ConsoleStreamRegistry getInstance() {
        if (current == null) {
            current = new ConsoleStreamRegistry();
        }
        return current;
    }

    public ConsoleStream getStream(LogContentType type) {
        if (type == null) {
            return null;
        }
        if (this.providers == null) {
            this.providers = this.loadProviders();
        }
        ConsoleStreamProvider supportedProvider = null;
        int i = 0;
        while (supportedProvider == null && i < this.providers.size()) {
            LogContentType[] supportedTypes;
            ConsoleStreamProvider provider = this.providers.get(i);
            LogContentType[] logContentTypeArray = supportedTypes = provider.getSupportedTypes();
            int n = supportedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                LogContentType tp = logContentTypeArray[n2];
                if (tp.equals((Object)type)) {
                    supportedProvider = provider;
                    break;
                }
                ++n2;
            }
            ++i;
        }
        return supportedProvider != null ? supportedProvider.getStream(type) : null;
    }

    public List<ConsoleStreamProvider> loadProviders() {
        ArrayList<ConsoleStreamProvider> providers = new ArrayList<ConsoleStreamProvider>();
        providers.add(new StdStreamProvider());
        providers.add(new TraceStreamProvider());
        providers.add(new ApplicationLogStreamProvider());
        return providers;
    }
}

