/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.eclipse.cft.server.ui.internal.UIWebNavigationHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class LinkWidget {
    private String label;
    private String location;
    private Label labelControl;
    private Hyperlink linkControl;
    private FormToolkit toolkit;
    private Composite parent;

    public LinkWidget(Composite parent, String label, String location, FormToolkit toolkit) {
        this.label = label;
        this.location = location;
        this.toolkit = toolkit;
        this.parent = parent;
    }

    public void createControl() {
        Composite linkComposite = new Composite(this.parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 5).applyTo(linkComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)linkComposite);
        if (this.toolkit != null) {
            this.labelControl = this.toolkit.createLabel(linkComposite, String.valueOf(this.label) + ":");
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.labelControl);
            this.labelControl.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.linkControl = this.toolkit.createHyperlink(linkComposite, this.location, 2);
            GridDataFactory.fillDefaults().grab(true, false).align(16384, 128).applyTo((Control)this.linkControl);
            this.linkControl.setBackground(this.toolkit.getColors().getBackground());
        } else {
            this.labelControl = new Label(linkComposite, 0);
            this.labelControl.setText(this.label);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.labelControl);
            this.linkControl = new Hyperlink(linkComposite, 2);
            GridDataFactory.fillDefaults().grab(true, false).hint(250, -1).applyTo((Control)this.linkControl);
            this.linkControl.setText(this.location);
        }
        this.linkControl.setForeground(JFaceColors.getActiveHyperlinkText((Display)this.linkControl.getDisplay()));
        this.linkControl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LinkWidget.this.navigate();
            }
        });
    }

    protected void navigate() {
        new UIWebNavigationHelper(this.location, this.label).navigate();
    }

    public void setVisible(boolean show) {
        if (this.labelControl != null) {
            this.labelControl.setVisible(show);
        }
        if (this.linkControl != null) {
            this.linkControl.setVisible(show);
        }
    }
}

