/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.net.URI;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.eclipse.cft.server.core.internal.ApplicationUrlValidator;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ApplicationUrlLookupService {
    private final Object domainsPerActiveSpaceLock = new Object();
    private final CloudFoundryServer cloudServer;
    private List<CloudDomain> domainsPerActiveSpace;
    private ApplicationUrlValidator validator;

    public ApplicationUrlLookupService(CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
        this.validator = new ApplicationUrlValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDomains(IProgressMonitor monitor) throws CoreException {
        Object object = this.domainsPerActiveSpaceLock;
        synchronized (object) {
            if (this.domainsPerActiveSpace == null) {
                this.domainsPerActiveSpace = this.cloudServer.getBehaviour().getDomainsForSpace(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CloudDomain> getDomains() {
        Object object = this.domainsPerActiveSpaceLock;
        synchronized (object) {
            if (this.domainsPerActiveSpace == null) {
                try {
                    this.refreshDomains((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.domainsPerActiveSpace;
    }

    public CloudApplicationURL getDefaultApplicationURL(String subDomain) throws CoreException {
        List<CloudDomain> domains = this.getDomains();
        if (domains == null || domains.isEmpty()) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ApplicationUrlLookupService_ERROR_GETDEFAULT_APP_URL, (Object)this.cloudServer.getServerId(), (Object)subDomain));
        }
        CloudApplicationURL appURL = this.validateCloudApplicationUrl(new CloudApplicationURL(subDomain, domains.get(0).getName()));
        return appURL;
    }

    public IStatus simpleValidation(String url) {
        return this.validator.isValid(url);
    }

    public CloudApplicationURL getCloudApplicationURL(String url) throws CoreException {
        URI newUri;
        IStatus isValidStatus = this.simpleValidation(url);
        if (!isValidStatus.isOK()) {
            throw new CoreException(isValidStatus);
        }
        List<CloudDomain> domains = this.getDomains();
        if (domains == null || domains.isEmpty()) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus(Messages.ApplicationUrlLookupService_ERROR_GET_CLOUD_URL));
        }
        try {
            newUri = URI.create(url);
        }
        catch (IllegalArgumentException e) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus(e));
        }
        String authority = newUri.getScheme() != null ? newUri.getAuthority() : newUri.getPath();
        String parsedDomainName = null;
        String parsedSubdomainName = null;
        if (authority != null) {
            for (CloudDomain domain : domains) {
                String domainName = domain.getName();
                String domainSegment = String.valueOf('.') + domainName;
                if (authority.equals(domainName)) {
                    parsedDomainName = domainName;
                    break;
                }
                if (!authority.endsWith(domainSegment)) continue;
                parsedDomainName = domainName;
                if (domainSegment.length() >= authority.length()) break;
                parsedSubdomainName = authority.substring(0, authority.lastIndexOf(domainSegment));
                break;
            }
        }
        if (parsedDomainName == null || parsedDomainName.trim().length() == 0) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.ERROR_NO_DOMAIN_RESOLVED_FOR_URL, (Object)url)));
        }
        if (parsedSubdomainName == null || (long)parsedSubdomainName.trim().length() == 0L) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.ERROR_INVALID_SUBDOMAIN, (Object)url, (Object)parsedDomainName)));
        }
        return new CloudApplicationURL(parsedSubdomainName, parsedDomainName);
    }

    public CloudApplicationURL validateCloudApplicationUrl(CloudApplicationURL url) throws CoreException {
        return this.getCloudApplicationURL(url.getUrl());
    }

    public static ApplicationUrlLookupService getCurrentLookup(CloudFoundryServer cloudServer) {
        ApplicationUrlLookupService service = cloudServer.getBehaviour().getApplicationUrlLookup();
        if (service == null) {
            service = new ApplicationUrlLookupService(cloudServer);
        }
        return service;
    }

    public static ApplicationUrlLookupService update(CloudFoundryServer cloudServer, IProgressMonitor monitor) throws CoreException {
        ApplicationUrlLookupService lookUp = ApplicationUrlLookupService.getCurrentLookup(cloudServer);
        lookUp.refreshDomains(monitor);
        return lookUp;
    }
}

