/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.io.StringWriter;

public class CloudApplicationURL {
    private String subdomain;
    private String domain;
    private String url;

    public CloudApplicationURL(String subdomain, String domain) {
        this.subdomain = subdomain;
        this.domain = domain;
        this.url = this.getSuggestedApplicationURL(subdomain, domain);
    }

    protected String getSuggestedApplicationURL(String subdomain, String domain) {
        if (subdomain == null && domain == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        if (subdomain != null) {
            writer.append(subdomain);
            if (domain != null) {
                writer.append('.');
            }
        }
        if (domain != null) {
            writer.append(domain);
        }
        return writer.toString();
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "CloudApplicationURL [subdomain=" + this.subdomain + ", domain=" + this.domain + ", url=" + this.url + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.subdomain == null ? 0 : this.subdomain.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CloudApplicationURL other = (CloudApplicationURL)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.subdomain == null ? other.subdomain != null : !this.subdomain.equals(other.subdomain)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

