/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.cloudfoundry.client.lib.rest.CloudControllerResponseErrorHandler;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class ExternalRestTemplate
extends RestTemplate {
    public ExternalRestTemplate() {
        this.createRestTemplate();
    }

    protected ClientHttpRequestFactory createRequestFactory() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties();
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return requestFactory;
    }

    protected void createRestTemplate() {
        this.setRequestFactory(this.createRequestFactory());
        this.setErrorHandler((ResponseErrorHandler)new CloudControllerResponseErrorHandler());
        this.setMessageConverters(this.getHttpMessageConverters());
    }

    protected List<HttpMessageConverter<?>> getHttpMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        return messageConverters;
    }
}

