/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.LinkedHashMap;
import java.util.List;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.CFOperation;
import org.eclipse.cft.server.core.internal.client.CFV1Application;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class UpdateAllOperation
extends CFOperation {
    public UpdateAllOperation(CloudFoundryServerBehaviour behaviour) {
        super(behaviour);
    }

    @Override
    public String getOperationName() {
        return Messages.UpdateAllOperation_OPERATION_MESSAGE;
    }

    protected boolean isCanceled(IProgressMonitor monitor) {
        return monitor != null && monitor.isCanceled();
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(NLS.bind((String)Messages.CloudBehaviourOperations_REFRESHING_APPS_AND_SERVICES, (Object)cloudServer.getServer().getId()), 100);
        if (this.isCanceled((IProgressMonitor)subMonitor)) {
            return;
        }
        List<CFServiceInstance> services = this.getBehaviour().getServices((IProgressMonitor)subMonitor.newChild(20));
        ServerEventHandler.getDefault().fireServicesUpdated(cloudServer, services);
        if (this.isCanceled((IProgressMonitor)subMonitor)) {
            return;
        }
        List<CloudApplication> applications = this.updateBasicListOfApps(cloudServer, subMonitor.newChild(30));
        ServerEventHandler.getDefault().fireModulesUpdated(cloudServer, cloudServer.getServer().getModules());
        this.updateCompleteApps(applications, cloudServer, subMonitor.newChild(70));
        subMonitor.worked(20);
    }

    protected List<CloudApplication> updateBasicListOfApps(CloudFoundryServer cloudServer, SubMonitor subMonitor) throws CoreException {
        List<CloudApplication> applications = this.getBehaviour().getBasicApplications((IProgressMonitor)subMonitor);
        LinkedHashMap<String, CloudApplication> deployedApplicationsByName = new LinkedHashMap<String, CloudApplication>();
        LinkedHashMap<String, ApplicationStats> stats = new LinkedHashMap<String, ApplicationStats>();
        for (CloudApplication application : applications) {
            deployedApplicationsByName.put(application.getName(), application);
        }
        boolean updateCloudMappingInExistingModules = false;
        cloudServer.addAndDeleteModules(deployedApplicationsByName, stats, updateCloudMappingInExistingModules);
        cloudServer.updateModulesState(new int[]{1});
        return applications;
    }

    protected void updateCompleteApps(List<CloudApplication> applications, CloudFoundryServer cloudServer, SubMonitor subMonitor) throws CoreException {
        if (applications == null) {
            return;
        }
        applications.parallelStream().forEach(cloudApp -> {
            if (this.isCanceled((IProgressMonitor)subMonitor)) {
                return;
            }
            try {
                CloudFoundryApplicationModule appModule;
                CFV1Application updatedApplication = this.getBehaviour().getCompleteApplication((CloudApplication)cloudApp, (IProgressMonitor)subMonitor);
                if (updatedApplication != null && updatedApplication.getStats() != null && (appModule = cloudServer.updateModule(updatedApplication.getApplication(), updatedApplication.getApplication().getName(), updatedApplication.getStats(), (IProgressMonitor)subMonitor)) != null) {
                    appModule.validateAndUpdateStatus();
                    ServerEventHandler.getDefault().fireModuleUpdated(cloudServer, appModule.getLocalModule());
                }
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(e);
            }
            subMonitor.worked(1);
        });
    }
}

