/*******************************************************************************
 * Copyright (c) 2012-2016 Codenvy, S.A.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Codenvy, S.A. - initial API and implementation
 *******************************************************************************/
package org.eclipse.che.api.workspace.shared.dto.compose;

import org.eclipse.che.api.core.model.workspace.compose.ComposeEnvironment;
import org.eclipse.che.dto.shared.DTO;

import java.util.Map;

/**
 * @author Alexander Garagatyi
 */
@DTO
public interface ComposeEnvironmentDto extends ComposeEnvironment {
    void setVersion(String version);

    ComposeEnvironmentDto withVersion(String version);

    @Override
    Map<String, ComposeServiceDto> getServices();

    void setServices(Map<String, ComposeServiceDto> services);

    ComposeEnvironmentDto withServices(Map<String, ComposeServiceDto> services);
}
