/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.AbstractPeakIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.IPeakIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.PeakIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentifierRemoveUnidentified
extends AbstractPeakIdentifier {
    @Override
    public IPeakIdentifierProcessingInfo identify(List<IPeakMSD> peaks, IPeakIdentifierSettings peakIdentifierSettings, IProgressMonitor monitor) {
        PeakIdentifierProcessingInfo processingInfo = new PeakIdentifierProcessingInfo();
        try {
            for (IPeakMSD peak : peaks) {
                IChromatogramPeakMSD chromatogramPeakMSD;
                IChromatogramMSD chromatogramMSD;
                if (!(peak instanceof IChromatogramPeakMSD) || (chromatogramMSD = (chromatogramPeakMSD = (IChromatogramPeakMSD)peak).getChromatogram()) == null || chromatogramPeakMSD.getTargets().size() != 0) continue;
                chromatogramMSD.removePeak(chromatogramPeakMSD);
            }
            processingInfo.addInfoMessage("Identifier", "Done - unidentified peaks have been removed.");
        }
        catch (Exception exception) {
            processingInfo.addErrorMessage("Identifier", "Something has gone wrong.");
        }
        return processingInfo;
    }

    @Override
    public IPeakIdentifierProcessingInfo identify(IPeakMSD peak, IPeakIdentifierSettings peakIdentifierSettings, IProgressMonitor monitor) {
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        peaks.add(peak);
        return this.identify(peaks, peakIdentifierSettings, monitor);
    }

    @Override
    public IPeakIdentifierProcessingInfo identify(IPeakMSD peak, IProgressMonitor monitor) {
        PeakIdentifierSettings peakIdentifierSettings = new PeakIdentifierSettings();
        return this.identify(peak, (IPeakIdentifierSettings)peakIdentifierSettings, monitor);
    }

    @Override
    public IPeakIdentifierProcessingInfo identify(List<IPeakMSD> peaks, IProgressMonitor monitor) {
        PeakIdentifierSettings peakIdentifierSettings = new PeakIdentifierSettings();
        return this.identify(peaks, (IPeakIdentifierSettings)peakIdentifierSettings, monitor);
    }
}

