/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.internal.massspectrum;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;

public class ComparatorCache {
    private static final int NUMBER_TOP_IONS = 12;
    private static Map<Integer, Set<Integer>> unknownTopIons = null;
    private static Map<Integer, Set<Integer>> referenceTopIons = null;
    private IonAbundanceComparator ionAbundanceComparator = new IonAbundanceComparator(SortOrder.DESC);

    public ComparatorCache() {
        this.initializeDatabaseMaps();
    }

    public boolean useReferenceForComparison(IScanMSD unknown, IScanMSD reference, double thresholdPreOptimization) {
        if (unknown == null || reference == null) {
            return false;
        }
        int keyUnknown = unknown.getIons().hashCode();
        if (!unknownTopIons.containsKey(keyUnknown)) {
            unknownTopIons.put(keyUnknown, this.extractTopIons(unknown));
        }
        int keyReference = unknown.getIons().hashCode();
        if (!referenceTopIons.containsKey(reference)) {
            referenceTopIons.put(keyReference, this.extractTopIons(reference));
        }
        Set<Integer> unknownIons = unknownTopIons.get(keyUnknown);
        Set<Integer> referenceIons = referenceTopIons.get(keyReference);
        return this.useReferenceForComparison(unknownIons, referenceIons, thresholdPreOptimization);
    }

    private boolean useReferenceForComparison(Set<Integer> unknownIons, Set<Integer> referenceIons, double thresholdPreOptimization) {
        int hits = 0;
        int size = unknownIons.size();
        if (size > 0) {
            for (int mz : unknownIons) {
                if (!referenceIons.contains(mz)) continue;
                ++hits;
            }
            double percentageHits = (double)hits / (double)referenceIons.size();
            if (percentageHits >= thresholdPreOptimization) {
                return true;
            }
        }
        return false;
    }

    private Set<Integer> extractTopIons(IScanMSD massSpectrum) {
        List ions = massSpectrum.getIons();
        Collections.sort(ions, this.ionAbundanceComparator);
        HashSet<Integer> topIons = new HashSet<Integer>();
        int size = ions.size() < 12 ? ions.size() : 12;
        int i = 0;
        while (i < size) {
            topIons.add(AbstractIon.getIon((double)((IIon)ions.get(i)).getIon()));
            ++i;
        }
        return topIons;
    }

    private void initializeDatabaseMaps() {
        if (unknownTopIons == null) {
            unknownTopIons = new HashMap<Integer, Set<Integer>>();
        }
        if (referenceTopIons == null) {
            referenceTopIons = new HashMap<Integer, Set<Integer>>();
        }
    }
}

